import {AdminPreservationPolicyRoutingModule} from "@admin/preservation-policy/admin-preservation-policy-routing.module";
import {AdminPreservationPolicyFormPresentational} from "@admin/preservation-policy/components/presentationals/admin-preservation-policy-form/admin-preservation-policy-form.presentational";
import {AdminPreservationPolicyCreateRoutable} from "@admin/preservation-policy/components/routables/admin-preservation-policy-create/admin-preservation-policy-create.routable";
import {AdminPreservationPolicyDetailEditRoutable} from "@admin/preservation-policy/components/routables/admin-preservation-policy-detail-edit/admin-preservation-policy-detail-edit.routable";
import {AdminPreservationPolicyListRoutable} from "@admin/preservation-policy/components/routables/admin-preservation-policy-list/admin-preservation-policy-list.routable";
import {AdminPreservationPolicyState} from "@admin/preservation-policy/stores/admin-preservation-policy.state";
import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";

const routables = [
  AdminPreservationPolicyListRoutable,
  AdminPreservationPolicyDetailEditRoutable,
  AdminPreservationPolicyCreateRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
  AdminPreservationPolicyFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminPreservationPolicyRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminPreservationPolicyState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminPreservationPolicyModule {
}
