import {AdminPreservationPolicyCreateRoutable} from "@admin/preservation-policy/components/routables/admin-preservation-policy-create/admin-preservation-policy-create.routable";
import {AdminPreservationPolicyDetailEditRoutable} from "@admin/preservation-policy/components/routables/admin-preservation-policy-detail-edit/admin-preservation-policy-detail-edit.routable";
import {AdminPreservationPolicyListRoutable} from "@admin/preservation-policy/components/routables/admin-preservation-policy-list/admin-preservation-policy-list.routable";
import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";
import {AdminPreservationPolicyState} from "./stores/admin-preservation-policy.state";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminPreservationPolicyListRoutable,
    data: {},
  },
  {
    path: AdminRoutesEnum.preservationPolicyDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminPreservationPolicyDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: AdminPreservationPolicyState.currentTitle,
    },
    children: [
      {
        path: AdminRoutesEnum.preservationPolicyEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
  {
    path: AdminRoutesEnum.preservationPolicyCreate,
    component: AdminPreservationPolicyCreateRoutable,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminPreservationPolicyRoutingModule {
}
