import {OrganizationalUnitPersonRole} from "@admin/models/organizational-unit-person-role.model";
import {OrganizationalUnitRole} from "@admin/models/organizational-unit-role.model";
import {AdminOrganizationalUnitPersonRoleStateModel} from "@admin/organizational-unit/stores/person-role/admin-organizational-unit-person-role.state";
import {adminPersonOrgUnitRoleActionNameSpace} from "@admin/person/stores/person-role/admin-person-orgunit-role.action";
import {Injectable} from "@angular/core";
import {ApiResourceNameEnum} from "@app/shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {environment} from "@environments/environment";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {
  ApiService,
  defaultRelation3TiersStateInitValue,
  NotificationService,
  QueryParameters,
  Relation3TiersForm,
  Relation3TiersState,
  Relation3TiersStateModel,
} from "solidify-frontend";

export const defaultAdminPersonOrgUnitRoleStateModel: () => AdminPersonOrgUnitRoleStateModel = () =>
  ({
    ...defaultRelation3TiersStateInitValue(),
    queryParameters: new QueryParameters(environment.maximalPageSizeToRetrievePaginationInfo),
  });

export interface AdminPersonOrgUnitRoleStateModel extends Relation3TiersStateModel<OrganizationalUnitRole> {
}

@Injectable()
@State<AdminPersonOrgUnitRoleStateModel>({
  name: LocalStateEnum.admin_person_organizationalUnitRole,
  defaults: {
    ...defaultAdminPersonOrgUnitRoleStateModel(),
  },
})
// PersonOrganizationalUnitController
export class AdminPersonOrgUnitRoleState extends Relation3TiersState<AdminPersonOrgUnitRoleStateModel, OrganizationalUnitRole, OrganizationalUnitPersonRole> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminPersonOrgUnitRoleActionNameSpace,
      resourceName: ApiResourceNameEnum.ORG_UNIT,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.people;
  }

  protected convertResourceInForm(resource: OrganizationalUnitRole): Relation3TiersForm {
    return {id: resource.resId, listId: resource.roles.map(r => r.resId)};
  }
}
