import {adminPersonInstitutionNamespace} from "@admin/person/stores/institutions/admin-people-institutions.action";
import {Injectable} from "@angular/core";
import {Institution} from "@models";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  ApiService,
  AssociationState,
  AssociationStateModel,
  defaultAssociationStateInitValue,
  NotificationService,
} from "solidify-frontend";

export interface AdminPersonInstitutionsStateModel extends AssociationStateModel<Institution> {
}

@Injectable()
@State<AdminPersonInstitutionsStateModel>({
  name: LocalStateEnum.admin_person_institutions,
  defaults: {
    ...defaultAssociationStateInitValue(),
  },
})
export class AdminPersonInstitutionsState extends AssociationState<AdminPersonInstitutionsStateModel, Institution> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminPersonInstitutionNamespace,
      resourceName: ApiResourceNameEnum.INSTITUTION,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.people;
  }
}
