import {OrganizationalUnitRole} from "@admin/models/organizational-unit-role.model";
import {adminPersonActionNameSpace} from "@admin/person/stores/admin-person.action";
import {
  AdminPersonState,
  AdminPersonStateModel,
} from "@admin/person/stores/admin-person.state";
import {AdminPersonInstitutionsAction} from "@admin/person/stores/institutions/admin-people-institutions.action";
import {AdminPersonInstitutionsState} from "@admin/person/stores/institutions/admin-people-institutions.state";
import {AdminPersonOrgUnitRoleAction} from "@admin/person/stores/person-role/admin-person-orgunit-role.action";
import {AdminPersonOrgUnitRoleState} from "@admin/person/stores/person-role/admin-person-orgunit-role.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {
  Institution,
  Person,
  Role,
} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractDetailEditCommonRoutable} from "@shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {sharedPersonActionNameSpace} from "@shared/stores/person/shared-person.action";
import {SharedRoleState} from "@shared/stores/role/shared-role.state";
import {Observable} from "rxjs";
import {
  MemoizedUtil,
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-person-detail-edit-routable",
  templateUrl: "./admin-person-detail-edit.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminPersonDetailEditRoutable extends SharedAbstractDetailEditCommonRoutable<Person, AdminPersonStateModel> {
  @Select(AdminPersonState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminPersonState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;
  listRoleObs: Observable<Role[]> = MemoizedUtil.list(this._store, SharedRoleState);
  selectedInstitutionsObs: Observable<Institution[]> = MemoizedUtil.selected(this._store, AdminPersonInstitutionsState);
  selectedOrgUnitRoleObs: Observable<OrganizationalUnitRole[]> = MemoizedUtil.selected(this._store, AdminPersonOrgUnitRoleState);

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedPersonActionNameSpace;

  readonly KEY_PARAM_NAME: keyof Person & string = "fullName";

  constructor(protected _store: Store,
              protected _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              public _dialog: MatDialog) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.admin_person, adminPersonActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
    this._store.dispatch(new AdminPersonOrgUnitRoleAction.GetAll(id));
    this._store.dispatch(new AdminPersonInstitutionsAction.GetAll(id));
  }
}
