import {AdminPersonFormPresentational} from "@admin/person/components/presentationals/admin-person-form/admin-person-form.presentational";
import {AdminPersonCreateRoutable} from "@admin/person/components/routables/admin-person-create/admin-person-create.routable";
import {AdminPersonDetailEditRoutable} from "@admin/person/components/routables/admin-person-detail-edit/admin-person-detail-edit.routable";
import {AdminPersonListRoutable} from "@admin/person/components/routables/admin-person-list/admin-person-list.routable";
import {AdminPersonState} from "@admin/person/stores/admin-person.state";
import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {AdminPersonRoutingModule} from "./admin-person-routing.module";

const routables = [
  AdminPersonListRoutable,
  AdminPersonDetailEditRoutable,
  AdminPersonCreateRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
  AdminPersonFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminPersonRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminPersonState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminPersonModule {
}
