import {AdminPersonCreateRoutable} from "@admin/person/components/routables/admin-person-create/admin-person-create.routable";
import {AdminPersonDetailEditRoutable} from "@admin/person/components/routables/admin-person-detail-edit/admin-person-detail-edit.routable";
import {AdminPersonListRoutable} from "@admin/person/components/routables/admin-person-list/admin-person-list.routable";
import {AdminPersonState} from "@admin/person/stores/admin-person.state";
import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {ApplicationRoleGuardService} from "@shared/guards/application-role-guard.service";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminPersonListRoutable,
    data: {},
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.personDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminPersonDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: AdminPersonState.currentTitle,
    },
    children: [
      {
        path: AdminRoutesEnum.personEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
  {
    path: AdminRoutesEnum.personCreate,
    component: AdminPersonCreateRoutable,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminPersonRoutingModule {
}
