import {OrganizationalUnitSubmissionPolicy} from "@admin/models/organizational-unit-submission-policy.model";
import {
  AdminOrganizationalUnitSubmissionPolicyAction,
  adminOrganizationalUnitSubmissionPolicyActionNameSpace,
} from "@admin/organizational-unit/stores/submission-policy/admin-organizational-unit-submission-policy.action";
import {Injectable} from "@angular/core";
import {SubmissionPolicy} from "@models";

import {
  Action,
  ActionCompletion,
  Actions,
  ofActionCompleted,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  Observable,
  of,
} from "rxjs";
import {tap} from "rxjs/operators";
import {
  ActionSubActionCompletionsWrapper,
  ApiService,
  BaseSubAction,
  defaultRelation2TiersStateInitValue,
  isEmptyArray,
  isNotNullNorUndefined,
  NotificationService,
  OverrideDefaultAction,
  Relation2TiersState,
  Relation2TiersStateModel,
  StoreUtil,
} from "solidify-frontend";

export interface AdminOrganizationalUnitSubmissionPolicyStateModel extends Relation2TiersStateModel<SubmissionPolicy> {
}

@Injectable()
@State<AdminOrganizationalUnitSubmissionPolicyStateModel>({
  name: LocalStateEnum.admin_organizationalUnit_submissionPolicy,
  defaults: {
    ...defaultRelation2TiersStateInitValue(),
  },
})
export class AdminOrganizationalUnitSubmissionPolicyState extends Relation2TiersState<AdminOrganizationalUnitSubmissionPolicyStateModel, SubmissionPolicy, OrganizationalUnitSubmissionPolicy> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminOrganizationalUnitSubmissionPolicyActionNameSpace,
      resourceName: ApiResourceNameEnum.SUB_POLICY,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }

  @OverrideDefaultAction()
  @Action(AdminOrganizationalUnitSubmissionPolicyAction.Update)
  update(ctx: StateContext<AdminOrganizationalUnitSubmissionPolicyStateModel>, action: AdminOrganizationalUnitSubmissionPolicyAction.Update): Observable<boolean> {
    return super.internalUpdate(ctx, action)
      .pipe(
        tap((isSuccess: boolean) => {
          if (!isSuccess) {
            ctx.dispatch(new AdminOrganizationalUnitSubmissionPolicyAction.UpdateFail(action, action.parentId));
            return;
          }
          this.updateSubResource(action, ctx)
            .subscribe(success => {
              if (success) {
                ctx.dispatch(new AdminOrganizationalUnitSubmissionPolicyAction.UpdateSuccess(action, action.parentId));
              } else {
                ctx.dispatch(new AdminOrganizationalUnitSubmissionPolicyAction.UpdateFail(action, action.parentId));
              }
            });
        }),
      );
  }

  private updateSubResource(action: AdminOrganizationalUnitSubmissionPolicyAction.Update, ctx: StateContext<AdminOrganizationalUnitSubmissionPolicyStateModel>): Observable<boolean> {
    const orgUnitId = action.parentId;

    const listActionSubActionCompletionsWrapper: ActionSubActionCompletionsWrapper[] = [];

    if (action.oldDefaultResId !== action.newDefaultResId) {
      if (isNotNullNorUndefined(action.oldDefaultResId) && action.newResId.includes(action.oldDefaultResId)) {
        listActionSubActionCompletionsWrapper.push({
          action: new AdminOrganizationalUnitSubmissionPolicyAction.UpdateRelation(orgUnitId, action.oldDefaultResId, {defaultPolicy: false} as OrganizationalUnitSubmissionPolicy),
          subActionCompletions: this.getSubActionCompletions(),
        });
      }

      if (isNotNullNorUndefined(action.newDefaultResId)) {
        listActionSubActionCompletionsWrapper.push({
          action: new AdminOrganizationalUnitSubmissionPolicyAction.UpdateRelation(orgUnitId, action.newDefaultResId, {defaultPolicy: true} as OrganizationalUnitSubmissionPolicy),
          subActionCompletions: this.getSubActionCompletions(),
        });
      }
    }
    if (isEmptyArray(listActionSubActionCompletionsWrapper)) {
      return of(true);
    }
    return StoreUtil.dispatchParallelActionAndWaitForSubActionsCompletion(ctx, listActionSubActionCompletionsWrapper);
  }

  private getSubActionCompletions(): Observable<ActionCompletion<BaseSubAction<AdminOrganizationalUnitSubmissionPolicyAction.UpdateRelation>, Error>>[] | undefined {
    return [
      this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitSubmissionPolicyAction.UpdateRelationSuccess)),
      this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitSubmissionPolicyAction.UpdateRelationFail)),
    ];
  }
}
