import {OrganizationalUnitPreservationPolicy} from "@admin/models/organizational-unit-preservation-policy.model";
import {
  AdminOrganizationalUnitPreservationPolicyAction,
  adminOrganizationalUnitPreservationPolicyActionNameSpace,
} from "@admin/organizational-unit/stores/preservation-policy/admin-organizational-unit-preservation-policy.action";
import {Injectable} from "@angular/core";
import {PreservationPolicy} from "@models";

import {
  Action,
  ActionCompletion,
  Actions,
  ofActionCompleted,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  Observable,
  of,
} from "rxjs";
import {tap} from "rxjs/operators";
import {
  ActionSubActionCompletionsWrapper,
  ApiService,
  BaseSubAction,
  defaultRelation2TiersStateInitValue,
  isEmptyArray,
  isNotNullNorUndefined,
  NotificationService,
  OverrideDefaultAction,
  Relation2TiersState,
  Relation2TiersStateModel,
  StoreUtil,
} from "solidify-frontend";

export interface AdminOrganizationalUnitPreservationPolicyStateModel extends Relation2TiersStateModel<PreservationPolicy> {
}

@Injectable()
@State<AdminOrganizationalUnitPreservationPolicyStateModel>({
  name: LocalStateEnum.admin_organizationalUnit_preservationPolicy,
  defaults: {
    ...defaultRelation2TiersStateInitValue(),
  },
})
export class AdminOrganizationalUnitPreservationPolicyState extends Relation2TiersState<AdminOrganizationalUnitPreservationPolicyStateModel, PreservationPolicy, OrganizationalUnitPreservationPolicy> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminOrganizationalUnitPreservationPolicyActionNameSpace,
      resourceName: ApiResourceNameEnum.PRES_POLICY,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }

  @OverrideDefaultAction()
  @Action(AdminOrganizationalUnitPreservationPolicyAction.Update)
  update(ctx: StateContext<AdminOrganizationalUnitPreservationPolicyStateModel>, action: AdminOrganizationalUnitPreservationPolicyAction.Update): Observable<boolean> {
    return super.internalUpdate(ctx, action)
      .pipe(
        tap((isSuccess: boolean) => {
          if (!isSuccess) {
            ctx.dispatch(new AdminOrganizationalUnitPreservationPolicyAction.UpdateFail(action, action.parentId));
            return;
          }
          this.updateSubResource(action, ctx)
            .subscribe(success => {
              if (success) {
                ctx.dispatch(new AdminOrganizationalUnitPreservationPolicyAction.UpdateSuccess(action, action.parentId));
              } else {
                ctx.dispatch(new AdminOrganizationalUnitPreservationPolicyAction.UpdateFail(action, action.parentId));
              }
            });
        }),
      );
  }

  private updateSubResource(action: AdminOrganizationalUnitPreservationPolicyAction.Update, ctx: StateContext<AdminOrganizationalUnitPreservationPolicyStateModel>): Observable<boolean> {
    const orgUnitId = action.parentId;

    const listActionSubActionCompletionsWrapper: ActionSubActionCompletionsWrapper[] = [];

    if (action.oldDefaultResId !== action.newDefaultResId) {
      if (isNotNullNorUndefined(action.oldDefaultResId) && action.newResId.includes(action.oldDefaultResId)) {
        listActionSubActionCompletionsWrapper.push({
          action: new AdminOrganizationalUnitPreservationPolicyAction.UpdateRelation(orgUnitId, action.oldDefaultResId, {defaultPolicy: false} as OrganizationalUnitPreservationPolicy),
          subActionCompletions: this.getSubActionCompletions(),
        });
      }

      if (isNotNullNorUndefined(action.newDefaultResId)) {
        listActionSubActionCompletionsWrapper.push({
          action: new AdminOrganizationalUnitPreservationPolicyAction.UpdateRelation(orgUnitId, action.newDefaultResId, {defaultPolicy: true} as OrganizationalUnitPreservationPolicy),
          subActionCompletions: this.getSubActionCompletions(),
        });
      }
    }
    if (isEmptyArray(listActionSubActionCompletionsWrapper)) {
      return of(true);
    }
    return StoreUtil.dispatchParallelActionAndWaitForSubActionsCompletion(ctx, listActionSubActionCompletionsWrapper);
  }

  private getSubActionCompletions(): Observable<ActionCompletion<BaseSubAction<AdminOrganizationalUnitPreservationPolicyAction.UpdateRelation>, Error>>[] | undefined {
    return [
      this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitPreservationPolicyAction.UpdateRelationSuccess)),
      this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitPreservationPolicyAction.UpdateRelationFail)),
    ];
  }
}
