import {OrganizationalUnitPersonRole} from "@admin/models/organizational-unit-person-role.model";
import {PersonRole} from "@admin/models/person-role.model";
import {
  AdminOrganizationalUnitAdditionalFieldsFormStateModel,
  defaultAdminOrganizationalUnitAdditionalFieldsFormStateModel,
} from "@admin/organizational-unit/stores/additional-fields-form/admin-organizational-unit-additional-fields-form.state";
import {adminOrganizationalUnitPersonRoleActionNameSpace} from "@admin/organizational-unit/stores/person-role/admin-organizational-unit-person-role.action";
import {Injectable} from "@angular/core";
import {ApiResourceNameEnum} from "@app/shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {environment} from "@environments/environment";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {
  ApiService,
  defaultCompositionStateInitValue,
  defaultRelation3TiersStateInitValue,
  NotificationService,
  QueryParameters,
  Relation3TiersForm,
  Relation3TiersState,
  Relation3TiersStateModel,
} from "solidify-frontend";

export const defaultAdminOrganizationalUnitPersonRoleStateModel: () => AdminOrganizationalUnitPersonRoleStateModel = () =>
  ({
    ...defaultRelation3TiersStateInitValue(),
    queryParameters: new QueryParameters(environment.maximalPageSizeToRetrievePaginationInfo),
  });

export interface AdminOrganizationalUnitPersonRoleStateModel extends Relation3TiersStateModel<PersonRole> {
}

@Injectable()
@State<AdminOrganizationalUnitPersonRoleStateModel>({
  name: LocalStateEnum.admin_organizationalUnit_personRole,
  defaults: {
    ...defaultAdminOrganizationalUnitPersonRoleStateModel(),
  },
})
// OrganizationalUnitPersonController
export class AdminOrganizationalUnitPersonRoleState extends Relation3TiersState<AdminOrganizationalUnitPersonRoleStateModel, PersonRole, OrganizationalUnitPersonRole> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminOrganizationalUnitPersonRoleActionNameSpace,
      resourceName: ApiResourceNameEnum.PERSON,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }

  protected convertResourceInForm(resource: PersonRole): Relation3TiersForm {
    return {id: resource.resId, listId: resource.roles.map(r => r.resId)};
  }
}
