import {PersonRole} from "@admin/models/person-role.model";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {
  Relation3TiersAction,
  Relation3TiersNameSpace,
  TypeDefaultAction,
} from "solidify-frontend";

const state = LocalStateEnum.admin_organizationalUnit_personRole;

export namespace AdminOrganizationalUnitPersonRoleAction {

  @TypeDefaultAction(state)
  export class GetAll extends Relation3TiersAction.GetAll {
  }

  @TypeDefaultAction(state)
  export class GetAllSuccess extends Relation3TiersAction.GetAllSuccess<PersonRole> {
  }

  @TypeDefaultAction(state)
  export class GetAllFail extends Relation3TiersAction.GetAllFail {
  }

  @TypeDefaultAction(state)
  export class GetById extends Relation3TiersAction.GetById {
  }

  @TypeDefaultAction(state)
  export class GetByIdSuccess extends Relation3TiersAction.GetByIdSuccess<PersonRole> {
  }

  @TypeDefaultAction(state)
  export class GetByIdFail extends Relation3TiersAction.GetByIdFail {
  }

  @TypeDefaultAction(state)
  export class Update extends Relation3TiersAction.Update {
  }

  @TypeDefaultAction(state)
  export class UpdateSuccess extends Relation3TiersAction.UpdateSuccess {
  }

  @TypeDefaultAction(state)
  export class UpdateFail extends Relation3TiersAction.UpdateFail {
  }

  // @TypeDefaultAction(state)
  // export class UpdateRelation extends Relation3TiersAction.UpdateRelation<OrganizationalUnitPreservationPolicy> {
  // }
  //
  // @TypeDefaultAction(state)
  // export class UpdateRelationSuccess extends Relation3TiersAction.UpdateRelationSuccess<OrganizationalUnitPreservationPolicy> {
  // }
  //
  // @TypeDefaultAction(state)
  // export class UpdateRelationFail extends Relation3TiersAction.UpdateRelationFail<OrganizationalUnitPreservationPolicy> {
  // }

  @TypeDefaultAction(state)
  export class Create extends Relation3TiersAction.Create {
  }

  @TypeDefaultAction(state)
  export class CreateSuccess extends Relation3TiersAction.CreateSuccess {
  }

  @TypeDefaultAction(state)
  export class CreateFail extends Relation3TiersAction.CreateFail {
  }

  @TypeDefaultAction(state)
  export class CreateResource extends Relation3TiersAction.CreateResource {
  }

  @TypeDefaultAction(state)
  export class CreateResourceSuccess extends Relation3TiersAction.CreateResourceSuccess {
  }

  @TypeDefaultAction(state)
  export class CreateResourceFail extends Relation3TiersAction.CreateResourceFail {
  }

  // @TypeDefaultAction(state)
  // export class DeleteList extends Relation3TiersAction.DeleteList {
  // }
  //
  // @TypeDefaultAction(state)
  // export class DeleteListSuccess extends Relation3TiersAction.DeleteListSuccess {
  // }
  //
  // @TypeDefaultAction(state)
  // export class DeleteListFail extends Relation3TiersAction.DeleteListFail {
  // }

  @TypeDefaultAction(state)
  export class Delete extends Relation3TiersAction.Delete {
  }

  @TypeDefaultAction(state)
  export class DeleteSuccess extends Relation3TiersAction.DeleteSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteFail extends Relation3TiersAction.DeleteFail {
  }
}

export const adminOrganizationalUnitPersonRoleActionNameSpace: Relation3TiersNameSpace = AdminOrganizationalUnitPersonRoleAction;
