import {adminOrganizationalUnitInstitutionNamespace} from "@admin/organizational-unit/stores/institution/admin-organizational-unit-institution.action";
import {Injectable} from "@angular/core";
import {Institution} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  ApiService,
  AssociationState,
  AssociationStateModel,
  defaultAssociationStateInitValue,
  NotificationService,
} from "solidify-frontend";

export interface AdminOrganizationalUnitInstitutionStateModel extends AssociationStateModel<Institution> {
}

@Injectable()
@State<AdminOrganizationalUnitInstitutionStateModel>({
  name: LocalStateEnum.admin_organizationalUnit_institution,
  defaults: {
    ...defaultAssociationStateInitValue(),
  },
})
export class AdminOrganizationalUnitInstitutionState extends AssociationState<AdminOrganizationalUnitInstitutionStateModel, Institution> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminOrganizationalUnitInstitutionNamespace,
      resourceName: ApiResourceNameEnum.INSTITUTION,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }
}
