import {adminOrganizationalUnitFundingAgencyNamespace} from "@admin/organizational-unit/stores/funding-agency/admin-organizational-unit-funding-agency.action";
import {Injectable} from "@angular/core";
import {FundingAgency} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  ApiService,
  AssociationState,
  AssociationStateModel,
  defaultAssociationStateInitValue,
  NotificationService,
} from "solidify-frontend";

export interface AdminOrganizationalUnitFundingAgencyStateModel extends AssociationStateModel<FundingAgency> {
}

@Injectable()
@State<AdminOrganizationalUnitFundingAgencyStateModel>({
  name: LocalStateEnum.admin_organizationalUnit_fundingAgency,
  defaults: {
    ...defaultAssociationStateInitValue(),
  },
})
export class AdminOrganizationalUnitFundingAgencyState extends AssociationState<AdminOrganizationalUnitFundingAgencyStateModel, FundingAgency> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminOrganizationalUnitFundingAgencyNamespace,
      resourceName: ApiResourceNameEnum.FUNDING_AGENCY,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }
}
