import {FundingAgency} from "@models";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  AssociationAction,
  AssociationNameSpace,
  TypeDefaultAction,
} from "solidify-frontend";

const state = LocalStateEnum.admin_organizationalUnit_fundingAgency;

export namespace AdminOrganizationalUnitFundingAgencyAction {

  @TypeDefaultAction(state)
  export class GetAll extends AssociationAction.GetAll {
  }

  @TypeDefaultAction(state)
  export class GetAllSuccess extends AssociationAction.GetAllSuccess<FundingAgency> {
  }

  @TypeDefaultAction(state)
  export class GetAllFail extends AssociationAction.GetAllFail {
  }

  @TypeDefaultAction(state)
  export class GetById extends AssociationAction.GetById {
  }

  @TypeDefaultAction(state)
  export class GetByIdSuccess extends AssociationAction.GetByIdSuccess<FundingAgency> {
  }

  @TypeDefaultAction(state)
  export class GetByIdFail extends AssociationAction.GetByIdFail {
  }

  @TypeDefaultAction(state)
  export class Update extends AssociationAction.Update {
  }

  @TypeDefaultAction(state)
  export class UpdateSuccess extends AssociationAction.UpdateSuccess {
  }

  @TypeDefaultAction(state)
  export class UpdateFail extends AssociationAction.UpdateFail {
  }

  @TypeDefaultAction(state)
  export class Create extends AssociationAction.Create {
  }

  @TypeDefaultAction(state)
  export class CreateSuccess extends AssociationAction.CreateSuccess {
  }

  @TypeDefaultAction(state)
  export class CreateFail extends AssociationAction.CreateFail {
  }

  @TypeDefaultAction(state)
  export class DeleteList extends AssociationAction.DeleteList {
  }

  @TypeDefaultAction(state)
  export class DeleteListSuccess extends AssociationAction.DeleteListSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteListFail extends AssociationAction.DeleteListFail {
  }

  @TypeDefaultAction(state)
  export class Delete extends AssociationAction.Delete {
  }

  @TypeDefaultAction(state)
  export class DeleteSuccess extends AssociationAction.DeleteSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteFail extends AssociationAction.DeleteFail {
  }
}

export const adminOrganizationalUnitFundingAgencyNamespace: AssociationNameSpace = AdminOrganizationalUnitFundingAgencyAction;
