import {OrganizationalUnitDisseminationPolicy} from "@admin/models/organizational-unit-dissemination-policy.model";
import {
  AdminOrganizationalUnitDisseminationPolicyAction,
  adminOrganizationalUnitDisseminationPolicyActionNameSpace,
} from "@admin/organizational-unit/stores/dissemination-policy/admin-organizational-unit-dissemination-policy.action";
import {Injectable} from "@angular/core";
import {DisseminationPolicy} from "@models";

import {
  Action,
  ActionCompletion,
  Actions,
  ofActionCompleted,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  Observable,
  of,
} from "rxjs";
import {tap} from "rxjs/operators";
import {
  ActionSubActionCompletionsWrapper,
  ApiService,
  BaseSubAction,
  defaultRelation2TiersStateInitValue,
  isEmptyArray,
  isNotNullNorUndefined,
  NotificationService,
  OverrideDefaultAction,
  Relation2TiersState,
  Relation2TiersStateModel,
  StoreUtil,
} from "solidify-frontend";

export interface AdminOrganizationalUnitDisseminationPolicyStateModel extends Relation2TiersStateModel<DisseminationPolicy> {
}

@Injectable()
@State<AdminOrganizationalUnitDisseminationPolicyStateModel>({
  name: LocalStateEnum.admin_organizationalUnit_disseminationPolicy,
  defaults: {
    ...defaultRelation2TiersStateInitValue(),
  },
})
export class AdminOrganizationalUnitDisseminationPolicyState extends Relation2TiersState<AdminOrganizationalUnitDisseminationPolicyStateModel, DisseminationPolicy, OrganizationalUnitDisseminationPolicy> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminOrganizationalUnitDisseminationPolicyActionNameSpace,
      resourceName: ApiResourceNameEnum.DISSEMINATION_POLICY,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }

  @OverrideDefaultAction()
  @Action(AdminOrganizationalUnitDisseminationPolicyAction.Update)
  update(ctx: StateContext<AdminOrganizationalUnitDisseminationPolicyStateModel>, action: AdminOrganizationalUnitDisseminationPolicyAction.Update): Observable<boolean> {
    return super.internalUpdate(ctx, action)
      .pipe(
        tap((isSuccess: boolean) => {
          if (!isSuccess) {
            ctx.dispatch(new AdminOrganizationalUnitDisseminationPolicyAction.UpdateFail(action, action.parentId));
            return;
          }
          this.updateSubResource(action, ctx)
            .subscribe(success => {
              if (success) {
                ctx.dispatch(new AdminOrganizationalUnitDisseminationPolicyAction.UpdateSuccess(action, action.parentId));
              } else {
                ctx.dispatch(new AdminOrganizationalUnitDisseminationPolicyAction.UpdateFail(action, action.parentId));
              }
            });
        }),
      );
  }

  private updateSubResource(action: AdminOrganizationalUnitDisseminationPolicyAction.Update, ctx: StateContext<AdminOrganizationalUnitDisseminationPolicyStateModel>): Observable<boolean> {
    const orgUnitId = action.parentId;

    const listActionSubActionCompletionsWrapper: ActionSubActionCompletionsWrapper[] = [];

    if (action.oldDefaultResId !== action.newDefaultResId) {
      if (isNotNullNorUndefined(action.oldDefaultResId) && action.newResId.includes(action.oldDefaultResId)) {
        listActionSubActionCompletionsWrapper.push({
          action: new AdminOrganizationalUnitDisseminationPolicyAction.UpdateRelation(orgUnitId, action.oldDefaultResId, {defaultPolicy: false} as OrganizationalUnitDisseminationPolicy),
          subActionCompletions: this.getSubActionCompletions(),
        });
      }

      if (isNotNullNorUndefined(action.newDefaultResId)) {
        listActionSubActionCompletionsWrapper.push({
          action: new AdminOrganizationalUnitDisseminationPolicyAction.UpdateRelation(orgUnitId, action.newDefaultResId, {defaultPolicy: true} as OrganizationalUnitDisseminationPolicy),
          subActionCompletions: this.getSubActionCompletions(),
        });
      }
    }
    if (isEmptyArray(listActionSubActionCompletionsWrapper)) {
      return of(true);
    }
    return StoreUtil.dispatchParallelActionAndWaitForSubActionsCompletion(ctx, listActionSubActionCompletionsWrapper);
  }

  private getSubActionCompletions(): Observable<ActionCompletion<BaseSubAction<AdminOrganizationalUnitDisseminationPolicyAction.UpdateRelation>, Error>>[] | undefined {
    return [
      this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitDisseminationPolicyAction.UpdateRelationSuccess)),
      this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitDisseminationPolicyAction.UpdateRelationFail)),
    ];
  }
}
