import {
  AdminOrganizationalUnitAdditionalFieldsFormState,
  AdminOrganizationalUnitAdditionalFieldsFormStateModel,
  defaultAdminOrganizationalUnitAdditionalFieldsFormStateModel,
} from "@admin/organizational-unit/stores/additional-fields-form/admin-organizational-unit-additional-fields-form.state";
import {
  AdminOrganizationalUnitAction,
  adminOrganizationalUnitActionNameSpace,
} from "@admin/organizational-unit/stores/admin-organizational-unit.action";
import {AdminOrganizationalUnitDisseminationPolicyAction} from "@admin/organizational-unit/stores/dissemination-policy/admin-organizational-unit-dissemination-policy.action";
import {
  AdminOrganizationalUnitDisseminationPolicyState,
  AdminOrganizationalUnitDisseminationPolicyStateModel,
} from "@admin/organizational-unit/stores/dissemination-policy/admin-organizational-unit-dissemination-policy.state";
import {AdminOrganizationalUnitFundingAgencyAction} from "@admin/organizational-unit/stores/funding-agency/admin-organizational-unit-funding-agency.action";
import {
  AdminOrganizationalUnitFundingAgencyState,
  AdminOrganizationalUnitFundingAgencyStateModel,
} from "@admin/organizational-unit/stores/funding-agency/admin-organizational-unit-funding-agency.state";
import {AdminOrganizationalUnitInstitutionAction} from "@admin/organizational-unit/stores/institution/admin-organizational-unit-institution.action";
import {
  AdminOrganizationalUnitInstitutionState,
  AdminOrganizationalUnitInstitutionStateModel,
} from "@admin/organizational-unit/stores/institution/admin-organizational-unit-institution.state";
import {AdminOrganizationalUnitPersonRoleAction} from "@admin/organizational-unit/stores/person-role/admin-organizational-unit-person-role.action";
import {
  AdminOrganizationalUnitPersonRoleState,
  AdminOrganizationalUnitPersonRoleStateModel,
  defaultAdminOrganizationalUnitPersonRoleStateModel,
} from "@admin/organizational-unit/stores/person-role/admin-organizational-unit-person-role.state";
import {AdminOrganizationalUnitPreservationPolicyAction} from "@admin/organizational-unit/stores/preservation-policy/admin-organizational-unit-preservation-policy.action";
import {
  AdminOrganizationalUnitPreservationPolicyState,
  AdminOrganizationalUnitPreservationPolicyStateModel,
} from "@admin/organizational-unit/stores/preservation-policy/admin-organizational-unit-preservation-policy.state";
import {AdminOrganizationalUnitSubmissionPolicyAction} from "@admin/organizational-unit/stores/submission-policy/admin-organizational-unit-submission-policy.action";
import {
  AdminOrganizationalUnitSubmissionPolicyState,
  AdminOrganizationalUnitSubmissionPolicyStateModel,
} from "@admin/organizational-unit/stores/submission-policy/admin-organizational-unit-submission-policy.state";
import {HttpClient} from "@angular/common/http";
import {Injectable} from "@angular/core";
import {AppAuthorizedOrganizationalUnitAction} from "@app/stores/authorized-organizational-unit/app-authorized-organizational-unit.action";
import {DepositStateModel} from "@deposit/stores/deposit.state";
import {OrganizationalUnit} from "@models";
import {
  Action,
  Actions,
  ofActionCompleted,
  Selector,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  AdminRoutesEnum,
  RoutesEnum,
} from "@shared/enums/routes.enum";
import {SharedDisseminationPolicyAction} from "@shared/stores/dissemination-policy/shared-dissemination-policy.action";
import {SharedPreservationPolicyAction} from "@shared/stores/preservation-policy/shared-preservation-policy.action";
import {ResourceLogoStateModel} from "@shared/stores/resource-logo/resource-logo-state.model";
import {
  defaultResourceLogoStateInitValue,
  ResourceLogoState,
  ResourceLogoStateModeEnum,
} from "@shared/stores/resource-logo/resource-logo.state";
import {SharedRoleAction} from "@shared/stores/role/shared-role.action";
import {SharedSubmissionPolicyAction} from "@shared/stores/submission-policy/shared-submission-policy.action";
import {Observable} from "rxjs";
import {tap} from "rxjs/operators";
import {
  ApiService,
  defaultAssociationStateInitValue,
  defaultRelation2TiersStateInitValue,
  defaultRelation3TiersStateInitValue,
  isArray,
  isNotNullNorUndefined,
  isNullOrUndefined,
  MARK_AS_TRANSLATABLE,
  ModelAttributeEnum,
  NotificationService,
  ObjectUtil,
  OverrideDefaultAction,
  Relation3TiersForm,
  StoreUtil,
  urlSeparator,
} from "solidify-frontend";

export interface AdminOrganizationalUnitStateModel extends ResourceLogoStateModel<OrganizationalUnit> {
  admin_organizationalUnit_submissionPolicy: AdminOrganizationalUnitSubmissionPolicyStateModel;
  admin_organizationalUnit_preservationPolicy: AdminOrganizationalUnitPreservationPolicyStateModel;
  admin_organizationalUnit_disseminationPolicy: AdminOrganizationalUnitDisseminationPolicyStateModel;
  admin_organizationalUnit_personRole: AdminOrganizationalUnitPersonRoleStateModel;
  admin_organizationalUnit_fundingAgency: AdminOrganizationalUnitFundingAgencyStateModel;
  admin_organizationalUnit_institution: AdminOrganizationalUnitInstitutionStateModel;
  admin_organizationalUnit_additionalFieldsForm: AdminOrganizationalUnitAdditionalFieldsFormStateModel;
}

@Injectable()
@State<AdminOrganizationalUnitStateModel>({
  name: LocalStateEnum.admin_organizationalUnit,
  defaults: {
    ...defaultResourceLogoStateInitValue(),
    admin_organizationalUnit_submissionPolicy: {...defaultRelation2TiersStateInitValue()},
    admin_organizationalUnit_preservationPolicy: {...defaultRelation2TiersStateInitValue()},
    admin_organizationalUnit_disseminationPolicy: {...defaultRelation2TiersStateInitValue()},
    admin_organizationalUnit_personRole: {...defaultAdminOrganizationalUnitPersonRoleStateModel()},
    admin_organizationalUnit_fundingAgency: {...defaultAssociationStateInitValue()},
    admin_organizationalUnit_institution: {...defaultAssociationStateInitValue()},
    admin_organizationalUnit_additionalFieldsForm: {...defaultAdminOrganizationalUnitAdditionalFieldsFormStateModel()},
  },
  children: [
    AdminOrganizationalUnitSubmissionPolicyState,
    AdminOrganizationalUnitPreservationPolicyState,
    AdminOrganizationalUnitDisseminationPolicyState,
    AdminOrganizationalUnitPersonRoleState,
    AdminOrganizationalUnitFundingAgencyState,
    AdminOrganizationalUnitInstitutionState,
    AdminOrganizationalUnitAdditionalFieldsFormState,
  ],
})
export class AdminOrganizationalUnitState extends ResourceLogoState<AdminOrganizationalUnitStateModel, OrganizationalUnit> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions,
              protected readonly _httpClient: HttpClient) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminOrganizationalUnitActionNameSpace,
      routeRedirectUrlAfterSuccessCreateAction: (resId: string) => RoutesEnum.adminOrganizationalUnitDetail + urlSeparator + resId + urlSeparator + AdminRoutesEnum.organizationalUnitData,
      routeRedirectUrlAfterSuccessUpdateAction: (resId: string) => RoutesEnum.adminOrganizationalUnitDetail + urlSeparator + resId + urlSeparator + AdminRoutesEnum.organizationalUnitData,
      routeRedirectUrlAfterSuccessDeleteAction: RoutesEnum.adminOrganizationalUnit,
      notificationResourceCreateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.organizationalUnit.notification.resource.create"),
      notificationResourceDeleteSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.organizationalUnit.notification.resource.delete"),
      notificationResourceUpdateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.organizationalUnit.notification.resource.update"),
    }, _httpClient, ResourceLogoStateModeEnum.logo);
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }

  protected get _urlLogoResource(): string {
    return this._urlResource;
  }

  @Selector()
  static isLoading(state: AdminOrganizationalUnitStateModel): boolean {
    return StoreUtil.isLoadingState(state);
  }

  @Selector()
  static isLoadingWithDependency(state: AdminOrganizationalUnitStateModel): boolean {
    return this.isLoading(state)
      || StoreUtil.isLoadingState(state.admin_organizationalUnit_submissionPolicy)
      || StoreUtil.isLoadingState(state.admin_organizationalUnit_preservationPolicy)
      || StoreUtil.isLoadingState(state.admin_organizationalUnit_disseminationPolicy)
      || StoreUtil.isLoadingState(state.admin_organizationalUnit_personRole)
      || StoreUtil.isLoadingState(state.admin_organizationalUnit_fundingAgency)
      || StoreUtil.isLoadingState(state.admin_organizationalUnit_institution);
  }

  @Selector()
  static currentTitle(state: AdminOrganizationalUnitStateModel): string | undefined {
    if (isNullOrUndefined(state.current)) {
      return undefined;
    }
    return state.current.name;
  }

  @Selector()
  static isReadyToBeDisplayed(state: AdminOrganizationalUnitStateModel): boolean {
    return this.isReadyToBeDisplayedInCreateMode
      && !isNullOrUndefined(state.current)
      && !isNullOrUndefined(state.admin_organizationalUnit_personRole.selected)
      && !isNullOrUndefined(state.admin_organizationalUnit_preservationPolicy.selected)
      && !isNullOrUndefined(state.admin_organizationalUnit_disseminationPolicy.selected)
      && !isNullOrUndefined(state.admin_organizationalUnit_submissionPolicy.selected)
      && !isNullOrUndefined(state.admin_organizationalUnit_fundingAgency.selected)
      && !isNullOrUndefined(state.admin_organizationalUnit_institution.selected);
  }

  @Selector()
  static isReadyToBeDisplayedInCreateMode(state: AdminOrganizationalUnitStateModel): boolean {
    return true;
  }

  @Action(AdminOrganizationalUnitAction.LoadResource)
  loadResource(ctx: StateContext<DepositStateModel>, action: AdminOrganizationalUnitAction.LoadResource): Observable<any> {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter + 1,
    });

    return StoreUtil.dispatchParallelActionAndWaitForSubActionsCompletion(ctx, [
      {
        action: new SharedPreservationPolicyAction.GetAll(undefined, false, false),
        subActionCompletions: [
          this.actions$.pipe(ofActionCompleted(SharedPreservationPolicyAction.GetAllSuccess)),
          this.actions$.pipe(ofActionCompleted(SharedPreservationPolicyAction.GetAllFail)),
        ],
      },
      {
        action: new SharedSubmissionPolicyAction.GetAll(undefined, false, false),
        subActionCompletions: [
          this.actions$.pipe(ofActionCompleted(SharedSubmissionPolicyAction.GetAllSuccess)),
          this.actions$.pipe(ofActionCompleted(SharedSubmissionPolicyAction.GetAllFail)),
        ],
      },
      {
        action: new SharedDisseminationPolicyAction.GetAll(undefined, false, false),
        subActionCompletions: [
          this.actions$.pipe(ofActionCompleted(SharedDisseminationPolicyAction.GetAllSuccess)),
          this.actions$.pipe(ofActionCompleted(SharedDisseminationPolicyAction.GetAllFail)),
        ],
      },
      {
        action: new SharedRoleAction.GetAll(undefined, false, false),
        subActionCompletions: [
          this.actions$.pipe(ofActionCompleted(SharedRoleAction.GetAllSuccess)),
          this.actions$.pipe(ofActionCompleted(SharedRoleAction.GetAllFail)),
        ],
      },
    ]).pipe(
      tap(success => {
        if (success) {
          ctx.dispatch(new AdminOrganizationalUnitAction.LoadResourceSuccess(action));
        } else {
          ctx.dispatch(new AdminOrganizationalUnitAction.LoadResourceFail(action));
        }
      }));
  }

  @OverrideDefaultAction()
  @Action(AdminOrganizationalUnitAction.Create)
  create(ctx: StateContext<AdminOrganizationalUnitStateModel>, action: AdminOrganizationalUnitAction.Create): Observable<OrganizationalUnit> {
    return super.internalCreate(ctx, action)
      .pipe(
        tap(model => {
          this.updateSubResource(model, action, ctx)
            .subscribe(success => {
              if (success) {
                ctx.dispatch(new AdminOrganizationalUnitAction.CreateSuccess(action, model));
              } else {
                ctx.dispatch(new AdminOrganizationalUnitAction.CreateFail(action));
              }
            });
        }),
      );
  }

  @OverrideDefaultAction()
  @Action(AdminOrganizationalUnitAction.CreateSuccess)
  createSuccess(ctx: StateContext<AdminOrganizationalUnitStateModel>, action: AdminOrganizationalUnitAction.CreateSuccess): void {
    super.createSuccess(ctx, action);
    ctx.dispatch(new AppAuthorizedOrganizationalUnitAction.GetAll());
  }

  @OverrideDefaultAction()
  @Action(AdminOrganizationalUnitAction.Update)
  update(ctx: StateContext<AdminOrganizationalUnitStateModel>, action: AdminOrganizationalUnitAction.Update): Observable<OrganizationalUnit> {
    return super.internalUpdate(ctx, action)
      .pipe(
        tap(model => {
          this.updateSubResource(model, action, ctx)
            .subscribe(success => {
              if (success) {
                ctx.dispatch(new AdminOrganizationalUnitAction.UpdateSuccess(action, model));
              } else {
                ctx.dispatch(new AdminOrganizationalUnitAction.UpdateFail(action));
              }
            });
        }),
      );
  }

  private updateSubResource(model: OrganizationalUnit, action: AdminOrganizationalUnitAction.Create | AdminOrganizationalUnitAction.Update, ctx: StateContext<AdminOrganizationalUnitStateModel>): Observable<boolean> {
    const orgUnitId = model.resId;

    let oldDefaultPreservationPolicyId = undefined;
    const newDefaultPreservationPolicyId = action.modelFormControlEvent.model.defaultPreservationPolicy.resId;
    const newPreservationPoliciesIds = action.modelFormControlEvent.model.preservationPolicies.map(p => p.resId);

    let oldDefaultSubmissionPolicyId = undefined;
    const newDefaultSubmissionPolicyId = action.modelFormControlEvent.model.defaultSubmissionPolicy.resId;
    const newSubmissionPoliciesIds = action.modelFormControlEvent.model.submissionPolicies.map(p => p.resId);

    let oldDefaultDisseminationPolicyId = undefined;
    const newDefaultDisseminationPolicyId = action.modelFormControlEvent.model.defaultDisseminationPolicy.resId;
    const newDisseminationPoliciesIds = action.modelFormControlEvent.model.disseminationPolicies.map(p => p.resId);

    const newFundingAgencyIds = action.modelFormControlEvent.model.fundingAgencies.map(p => p.resId);

    const newInstitutionsIds = action.modelFormControlEvent.model.institutions.map(p => p.resId);

    if (!isNullOrUndefined(ctx.getState().current)) {
      oldDefaultPreservationPolicyId = ObjectUtil.getValue(ctx.getState().current.defaultPreservationPolicy, ModelAttributeEnum.resId) as string;
      oldDefaultSubmissionPolicyId = ObjectUtil.getValue(ctx.getState().current.defaultSubmissionPolicy, ModelAttributeEnum.resId) as string;
      oldDefaultDisseminationPolicyId = ObjectUtil.getValue(ctx.getState().current.defaultDisseminationPolicy, ModelAttributeEnum.resId) as string;
    }
    const newPersonRole = action.modelFormControlEvent.formControl.get("personRole").value as Relation3TiersForm[];
    newPersonRole.forEach((elem) => {
      if (!isNullOrUndefined(elem.listId) && !isArray(elem.listId)) {
        elem.listId = [elem.listId];
      }
    });

    return StoreUtil.dispatchSequentialActionAndWaitForSubActionsCompletion(ctx, [
      {
        action: new AdminOrganizationalUnitPreservationPolicyAction.Update(orgUnitId, newPreservationPoliciesIds, oldDefaultPreservationPolicyId, newDefaultPreservationPolicyId),
        subActionCompletions: [
          this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitPreservationPolicyAction.UpdateSuccess)),
          this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitPreservationPolicyAction.UpdateFail)),
        ],
      },
      {
        action: new AdminOrganizationalUnitSubmissionPolicyAction.Update(orgUnitId, newSubmissionPoliciesIds, oldDefaultSubmissionPolicyId, newDefaultSubmissionPolicyId),
        subActionCompletions: [
          this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitSubmissionPolicyAction.UpdateSuccess)),
          this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitSubmissionPolicyAction.UpdateFail)),
        ],
      },
      {
        action: new AdminOrganizationalUnitDisseminationPolicyAction.Update(orgUnitId, newDisseminationPoliciesIds, oldDefaultDisseminationPolicyId, newDefaultDisseminationPolicyId),
        subActionCompletions: [
          this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitDisseminationPolicyAction.UpdateSuccess)),
          this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitDisseminationPolicyAction.UpdateFail)),
        ],
      },
      {
        action: new AdminOrganizationalUnitPersonRoleAction.Update(orgUnitId, newPersonRole),
        subActionCompletions: [
          this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitPersonRoleAction.UpdateSuccess)),
          this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitPersonRoleAction.UpdateFail)),
        ],
      },
      {
        action: new AdminOrganizationalUnitFundingAgencyAction.Update(orgUnitId, newFundingAgencyIds),
        subActionCompletions: [
          this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitFundingAgencyAction.UpdateSuccess)),
          this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitFundingAgencyAction.UpdateFail)),
        ],
      },
      {
        action: new AdminOrganizationalUnitInstitutionAction.Update(orgUnitId, newInstitutionsIds),
        subActionCompletions: [
          this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitInstitutionAction.UpdateSuccess)),
          this.actions$.pipe(ofActionCompleted(AdminOrganizationalUnitInstitutionAction.UpdateFail)),
        ],
      },
    ]);
  }

  @OverrideDefaultAction()
  @Action(AdminOrganizationalUnitAction.GetByIdSuccess)
  getByIdSuccess(ctx: StateContext<AdminOrganizationalUnitStateModel>, action: AdminOrganizationalUnitAction.GetByIdSuccess): void {
    super.getByIdSuccess(ctx, action);
    if (isNotNullNorUndefined(action.model.logo)) {
      ctx.dispatch(new AdminOrganizationalUnitAction.GetPhoto(action.model.resId));
    }
  }

  @OverrideDefaultAction()
  @Action(AdminOrganizationalUnitAction.DeleteSuccess)
  deleteSuccess(ctx: StateContext<AdminOrganizationalUnitStateModel>, action: AdminOrganizationalUnitAction.DeleteSuccess): void {
    super.deleteSuccess(ctx, action);
    ctx.dispatch(new AppAuthorizedOrganizationalUnitAction.GetAll());
  }
}
