import {
  AdminOrganizationalUnitAdditionalFieldsFormAction,
  adminOrganizationalUnitAdditionalFieldsFormActionNameSpace,
} from "@admin/organizational-unit/stores/additional-fields-form/admin-organizational-unit-additional-fields-form.action";
import {Injectable} from "@angular/core";
import {AdditionalFieldsForm} from "@models";
import {
  Action,
  Actions,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Observable} from "rxjs";
import {
  catchError,
  tap,
} from "rxjs/operators";
import {
  ApiService,
  CompositionState,
  CompositionStateModel,
  defaultCompositionStateInitValue,
  MARK_AS_TRANSLATABLE,
  NotificationService,
  OverrideDefaultAction,
  QueryParameters,
  SolidifyStateError,
} from "solidify-frontend";
import GetCurrentMetadataFormFail = AdminOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataFormFail;
import GetCurrentMetadataFormSuccess = AdminOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataFormSuccess;

export const defaultAdminOrganizationalUnitAdditionalFieldsFormStateModel: () => AdminOrganizationalUnitAdditionalFieldsFormStateModel = () =>
  ({
    ...defaultCompositionStateInitValue(),
    queryParameters: new QueryParameters(20),
    loaded: false,
  });

export interface AdminOrganizationalUnitAdditionalFieldsFormStateModel extends CompositionStateModel<AdditionalFieldsForm> {
  loaded: boolean;
}

@Injectable()
@State<AdminOrganizationalUnitAdditionalFieldsFormStateModel>({
  name: LocalStateEnum.admin_organizationalUnit_additionalFieldsForm,
  defaults: {
    ...defaultAdminOrganizationalUnitAdditionalFieldsFormStateModel(),
  },
})
export class AdminOrganizationalUnitAdditionalFieldsFormState extends CompositionState<AdminOrganizationalUnitAdditionalFieldsFormStateModel, AdditionalFieldsForm> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminOrganizationalUnitAdditionalFieldsFormActionNameSpace,
      resourceName: ApiResourceNameEnum.ADDITIONAL_FIELDS_FORM,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }

  @Action(AdminOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataForm)
  getCurrentMetadataForm(ctx: StateContext<AdminOrganizationalUnitAdditionalFieldsFormStateModel>, action: AdminOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataForm): Observable<AdditionalFieldsForm> {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter + 1,
    });
    return this.apiService.getByIdInPath<AdditionalFieldsForm>(`${this._urlResource}/${action.parentId}/${this._resourceName}/${ApiResourceNameEnum.CURRENT_VERSION}`)
      .pipe(
        tap(result => ctx.dispatch(new GetCurrentMetadataFormSuccess(action, result))),
        catchError(error => {
          ctx.dispatch(new GetCurrentMetadataFormFail(action));
          throw new SolidifyStateError(this, error);
        }),
      );
  }

  @Action(AdminOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataFormSuccess)
  getCurrentMetadataFormSuccess(ctx: StateContext<AdminOrganizationalUnitAdditionalFieldsFormStateModel>, action: AdminOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataFormSuccess): void {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter - 1,
      current: action.currentForm,
      loaded: true,
    });
  }

  @Action(AdminOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataFormFail)
  getCurrentMetadataFormFail(ctx: StateContext<AdminOrganizationalUnitAdditionalFieldsFormStateModel>, action: AdminOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataFormFail): void {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter - 1,
    });
  }

  @OverrideDefaultAction()
  @Action(AdminOrganizationalUnitAdditionalFieldsFormAction.CreateSuccess)
  createSuccess(ctx: StateContext<AdminOrganizationalUnitAdditionalFieldsFormStateModel>, action: AdminOrganizationalUnitAdditionalFieldsFormAction.CreateSuccess): void {
    super.createSuccess(ctx, action);
    this.notificationService.showError(MARK_AS_TRANSLATABLE("admin.organizationalUnit.additionalFieldsForm.notification.unableToCreate"));
  }
}
