import {AdditionalFieldsForm} from "@models";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  BaseAction,
  BaseSubAction,
  CompositionAction,
  CompositionNameSpace,
  QueryParameters,
  TypeDefaultAction,
} from "solidify-frontend";

const state = LocalStateEnum.admin_organizationalUnit_additionalFieldsForm;

export namespace AdminOrganizationalUnitAdditionalFieldsFormAction {
  @TypeDefaultAction(state)
  export class GetAll extends CompositionAction.GetAll {
  }

  @TypeDefaultAction(state)
  export class GetAllSuccess extends CompositionAction.GetAllSuccess<AdditionalFieldsForm> {
  }

  @TypeDefaultAction(state)
  export class GetAllFail extends CompositionAction.GetAllFail {
  }

  @TypeDefaultAction(state)
  export class GetById extends CompositionAction.GetById {
  }

  @TypeDefaultAction(state)
  export class GetByIdSuccess extends CompositionAction.GetByIdSuccess<AdditionalFieldsForm> {
  }

  @TypeDefaultAction(state)
  export class GetByIdFail extends CompositionAction.GetByIdFail {
  }

  @TypeDefaultAction(state)
  export class Update extends CompositionAction.Update<AdditionalFieldsForm> {
  }

  @TypeDefaultAction(state)
  export class UpdateSuccess extends CompositionAction.UpdateSuccess<AdditionalFieldsForm> {
  }

  @TypeDefaultAction(state)
  export class UpdateFail extends CompositionAction.UpdateFail<AdditionalFieldsForm> {
  }

  @TypeDefaultAction(state)
  export class Create extends CompositionAction.Create<AdditionalFieldsForm> {
  }

  @TypeDefaultAction(state)
  export class CreateSuccess extends CompositionAction.CreateSuccess<AdditionalFieldsForm> {
  }

  @TypeDefaultAction(state)
  export class CreateFail extends CompositionAction.CreateFail<AdditionalFieldsForm> {
  }

  @TypeDefaultAction(state)
  export class Delete extends CompositionAction.Delete {
  }

  @TypeDefaultAction(state)
  export class DeleteSuccess extends CompositionAction.DeleteSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteFail extends CompositionAction.DeleteFail {
  }

  @TypeDefaultAction(state)
  export class ChangeQueryParameters extends CompositionAction.ChangeQueryParameters {
    static readonly type: string = `[${state}] Change Query Parameters`;

    constructor(public parentId: string, public queryParameters: QueryParameters, public keepCurrentContext: boolean = false, public getAllAfterChange: boolean = true) {
      super(parentId, queryParameters, keepCurrentContext, getAllAfterChange);
    }
  }

  export class GetCurrentMetadataForm extends BaseAction {
    static readonly type: string = `[${state}] Get Current Metadata Form`;

    constructor(public parentId: string) {
      super();
    }
  }

  export class GetCurrentMetadataFormSuccess extends BaseSubAction<GetCurrentMetadataForm> {
    static readonly type: string = `[${state}] Get Current Metadata Form Success`;

    constructor(public parentAction: GetCurrentMetadataForm, public currentForm: AdditionalFieldsForm) {
      super(parentAction);
    }
  }

  export class GetCurrentMetadataFormFail extends BaseSubAction<GetCurrentMetadataForm> {
    static readonly type: string = `[${state}] Get Current Metadata Form Fail`;
  }
}

export const adminOrganizationalUnitAdditionalFieldsFormActionNameSpace: CompositionNameSpace = AdminOrganizationalUnitAdditionalFieldsFormAction;
