import {PersonRole} from "@admin/models/person-role.model";
import {AdminOrganizationalUnitFormPresentational} from "@admin/organizational-unit/components/presentationals/admin-organizational-unit-form/admin-organizational-unit-form.presentational";
import {AdminOrganizationalUnitService} from "@admin/organizational-unit/services/admin-organizational-unit.service";
import {adminOrganizationalUnitActionNameSpace} from "@admin/organizational-unit/stores/admin-organizational-unit.action";
import {
  AdminOrganizationalUnitState,
  AdminOrganizationalUnitStateModel,
} from "@admin/organizational-unit/stores/admin-organizational-unit.state";
import {AdminOrganizationalUnitDisseminationPolicyAction} from "@admin/organizational-unit/stores/dissemination-policy/admin-organizational-unit-dissemination-policy.action";
import {AdminOrganizationalUnitDisseminationPolicyState} from "@admin/organizational-unit/stores/dissemination-policy/admin-organizational-unit-dissemination-policy.state";
import {AdminOrganizationalUnitFundingAgencyAction} from "@admin/organizational-unit/stores/funding-agency/admin-organizational-unit-funding-agency.action";
import {AdminOrganizationalUnitFundingAgencyState} from "@admin/organizational-unit/stores/funding-agency/admin-organizational-unit-funding-agency.state";
import {AdminOrganizationalUnitInstitutionAction} from "@admin/organizational-unit/stores/institution/admin-organizational-unit-institution.action";
import {AdminOrganizationalUnitInstitutionState} from "@admin/organizational-unit/stores/institution/admin-organizational-unit-institution.state";
import {AdminOrganizationalUnitPersonRoleAction} from "@admin/organizational-unit/stores/person-role/admin-organizational-unit-person-role.action";
import {AdminOrganizationalUnitPersonRoleState} from "@admin/organizational-unit/stores/person-role/admin-organizational-unit-person-role.state";
import {AdminOrganizationalUnitPreservationPolicyAction} from "@admin/organizational-unit/stores/preservation-policy/admin-organizational-unit-preservation-policy.action";
import {AdminOrganizationalUnitPreservationPolicyState} from "@admin/organizational-unit/stores/preservation-policy/admin-organizational-unit-preservation-policy.state";
import {AdminOrganizationalUnitSubmissionPolicyAction} from "@admin/organizational-unit/stores/submission-policy/admin-organizational-unit-submission-policy.action";
import {AdminOrganizationalUnitSubmissionPolicyState} from "@admin/organizational-unit/stores/submission-policy/admin-organizational-unit-submission-policy.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnInit,
  ViewChild,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {AppSystemPropertyState} from "@app/stores/system-property/app-system-property.state";
import {
  DisseminationPolicy,
  FundingAgency,
  Institution,
  OrganizationalUnit,
  PreservationPolicy,
  Role,
  SubmissionPolicy,
  SystemProperty,
} from "@models";
import {Navigate} from "@ngxs/router-plugin";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractDetailEditCommonRoutable} from "@shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  AdminRoutesEnum,
  DepositRoutesEnum,
  RoutesEnum,
} from "@shared/enums/routes.enum";
import {SharedDisseminationPolicyState} from "@shared/stores/dissemination-policy/shared-dissemination-policy.state";
import {sharedOrganizationalUnitActionNameSpace} from "@shared/stores/organizational-unit/shared-organizational-unit.action";
import {SharedPreservationPolicyState} from "@shared/stores/preservation-policy/shared-preservation-policy.state";
import {SharedResearchDomainAction} from "@shared/stores/research-domain/shared-research-domain.action";
import {SharedResearchDomainState} from "@shared/stores/research-domain/shared-research-domain.state";
import {SharedRoleState} from "@shared/stores/role/shared-role.state";
import {SharedSubmissionPolicyState} from "@shared/stores/submission-policy/shared-submission-policy.state";
import {Observable} from "rxjs";
import {
  filter,
  tap,
} from "rxjs/operators";
import {
  isNotNullNorUndefined,
  MemoizedUtil,
  Override,
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-organizational-unit-detail-edit-routable",
  templateUrl: "./admin-organizational-unit-metadata.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOrganizationalUnitMetadataRoutable extends SharedAbstractDetailEditCommonRoutable<OrganizationalUnit, AdminOrganizationalUnitStateModel> implements OnInit {
  @Select(AdminOrganizationalUnitState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminOrganizationalUnitState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;
  selectedSubmissionPoliciesObs: Observable<SubmissionPolicy[]> = MemoizedUtil.selected(this._store, AdminOrganizationalUnitSubmissionPolicyState);
  selectedPreservationPoliciesObs: Observable<PreservationPolicy[]> = MemoizedUtil.selected(this._store, AdminOrganizationalUnitPreservationPolicyState);
  selectedDisseminationPoliciesObs: Observable<DisseminationPolicy[]> = MemoizedUtil.selected(this._store, AdminOrganizationalUnitDisseminationPolicyState);
  selectedFundingAgenciesObs: Observable<FundingAgency[]> = MemoizedUtil.selected(this._store, AdminOrganizationalUnitFundingAgencyState);
  listSubmissionPoliciesObs: Observable<SubmissionPolicy[]> = MemoizedUtil.list(this._store, SharedSubmissionPolicyState);
  listPreservationPoliciesObs: Observable<PreservationPolicy[]> = MemoizedUtil.list(this._store, SharedPreservationPolicyState);
  listDisseminationPoliciesObs: Observable<DisseminationPolicy[]> = MemoizedUtil.list(this._store, SharedDisseminationPolicyState);
  listRoleObs: Observable<Role[]> = MemoizedUtil.list(this._store, SharedRoleState);
  selectedPersonRoleObs: Observable<PersonRole[]> = MemoizedUtil.selected(this._store, AdminOrganizationalUnitPersonRoleState);
  selectedInstitutionsObs: Observable<Institution[]> = MemoizedUtil.selected(this._store, AdminOrganizationalUnitInstitutionState);
  researchDomainSourcesObs: Observable<string[]> = MemoizedUtil.select(this._store, SharedResearchDomainState, state => state.sources);
  systemPropertyObs: Observable<SystemProperty> = MemoizedUtil.select(this._store, AppSystemPropertyState, state => state.current);

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedOrganizationalUnitActionNameSpace;

  @OverrideProperty()
  @ViewChild("formPresentational")
  readonly formPresentational: AdminOrganizationalUnitFormPresentational;

  readonly KEY_PARAM_NAME: keyof OrganizationalUnit & string = "name";

  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              public readonly _dialog: MatDialog,
              private readonly _adminOrganizationalUnitService: AdminOrganizationalUnitService) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.admin_organizationalUnit, adminOrganizationalUnitActionNameSpace, LocalStateEnum.admin);
  }

  ngOnInit(): void {
    super.ngOnInit();
    this._store.dispatch(new SharedResearchDomainAction.GetSource());

    this.subscribe(this.isReadyToBeDisplayedObs.pipe(
      filter(ready => ready && isNotNullNorUndefined(this.formPresentational)),
      tap(ready => {
        this._adminOrganizationalUnitService.formPresentational = this.formPresentational;
      })),
    );
  }

  getSubResourceWithParentId(id: string): void {
    this._store.dispatch(new AdminOrganizationalUnitSubmissionPolicyAction.GetAll(id));
    this._store.dispatch(new AdminOrganizationalUnitPreservationPolicyAction.GetAll(id));
    this._store.dispatch(new AdminOrganizationalUnitDisseminationPolicyAction.GetAll(id));
    this._store.dispatch(new AdminOrganizationalUnitPersonRoleAction.GetAll(id));
    this._store.dispatch(new AdminOrganizationalUnitFundingAgencyAction.GetAll(id));
    this._store.dispatch(new AdminOrganizationalUnitInstitutionAction.GetAll(id));
  }

  @Override()
  edit(): void {
    if (this.isEdit) {
      return;
    }
    this._store.dispatch(new Navigate([RoutesEnum.adminOrganizationalUnitDetail, this._resId, AdminRoutesEnum.organizationalUnitData, DepositRoutesEnum.edit], {}, {skipLocationChange: true}));
  }

  @Override()
  protected cleanState(): void {
  }
}
