import {adminOrganizationalUnitActionNameSpace} from "@admin/organizational-unit/stores/admin-organizational-unit.action";
import {AdminOrganizationalUnitStateModel} from "@admin/organizational-unit/stores/admin-organizational-unit.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {OrganizationalUnit} from "@models";
import {Navigate} from "@ngxs/router-plugin";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {DataTestEnum} from "@shared/enums/data-test.enum";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  AdminRoutesEnum,
  RoutesEnum,
} from "@shared/enums/routes.enum";
import {RouterExtService} from "@shared/services/router-ext.service";
import {
  OrderEnum,
  Override,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-organizational-unit-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOrganizationalUnitListRoutable extends SharedAbstractListRoutable<OrganizationalUnit, AdminOrganizationalUnitStateModel> {
  readonly KEY_CREATE_BUTTON: string = LabelTranslateEnum.create;
  readonly KEY_BACK_BUTTON: string | undefined = LabelTranslateEnum.backToAdmin;
  readonly KEY_PARAM_NAME: keyof OrganizationalUnit & string = "name";

  constructor(protected readonly _store: Store,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _route: ActivatedRoute,
              protected readonly _routerExt: RouterExtService,
              protected readonly _actions$: Actions,
              protected readonly _dialog: MatDialog) {
    super(_store, _changeDetector, _route, _routerExt, _actions$, _dialog, LocalStateEnum.admin_organizationalUnit, adminOrganizationalUnitActionNameSpace, {}, LocalStateEnum.admin);
  }

  conditionDisplayEditButton(model: OrganizationalUnit | undefined): boolean {
    return true;
  }

  conditionDisplayDeleteButton(model: OrganizationalUnit | undefined): boolean {
    return true;
  }

  @Override()
  goToEdit(model: OrganizationalUnit): void {
    this._store.dispatch(new Navigate([RoutesEnum.adminOrganizationalUnitDetail, model.resId, AdminRoutesEnum.organizationalUnitData, AdminRoutesEnum.organizationalUnitEdit], {}, {skipLocationChange: true}));
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "name",
        header: LabelTranslateEnum.nameLabel,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
        dataTest: DataTestEnum.adminOrgUnitListSearchName,
      },
      {
        field: "openingDate",
        header: LabelTranslateEnum.opening,
        type: FieldTypeEnum.date,
        order: OrderEnum.descending,
        isFilterable: false,
        isSortable: true,
      },
      {
        field: "closingDate" as any,
        header: LabelTranslateEnum.closing,
        type: FieldTypeEnum.date,
        order: OrderEnum.none,
        isFilterable: false,
        isSortable: true,
      },
    ];
  }
}
