import {
  AdminOrganizationalUnitAdditionalFieldsDetailCreateEditDialogData,
  AdminOrganizationalUnitAdditionalFieldsDetailCreateUpdateDialog,
} from "@admin/organizational-unit/components/dialogs/admin-organizational-unit-additional-fields-detail-create-update/admin-organizational-unit-additional-fields-detail-create-update.dialog";
import {AdminOrganizationalUnitService} from "@admin/organizational-unit/services/admin-organizational-unit.service";
import {adminOrganizationalUnitActionNameSpace} from "@admin/organizational-unit/stores/admin-organizational-unit.action";
import {
  AdminOrganizationalUnitState,
  AdminOrganizationalUnitStateModel,
} from "@admin/organizational-unit/stores/admin-organizational-unit.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnInit,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {
  OrganizationalUnit,
  PreservationPolicy,
  Role,
  SubmissionPolicy,
} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {Tab} from "@shared/components/containers/shared-tabs/shared-tabs.container";
import {SharedAbstractDetailEditCommonRoutable} from "@shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {ExtraButtonToolbar} from "@shared/models/extra-button-toolbar.model";
import {sharedOrganizationalUnitActionNameSpace} from "@shared/stores/organizational-unit/shared-organizational-unit.action";
import {SharedPreservationPolicyState} from "@shared/stores/preservation-policy/shared-preservation-policy.state";
import {SharedResearchDomainAction} from "@shared/stores/research-domain/shared-research-domain.action";
import {SharedRoleState} from "@shared/stores/role/shared-role.state";
import {SharedSubmissionPolicyState} from "@shared/stores/submission-policy/shared-submission-policy.state";
import {Observable} from "rxjs";
import {
  MARK_AS_TRANSLATABLE,
  MemoizedUtil,
  Override,
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-organizational-unit-detail-edit-routable",
  templateUrl: "./admin-organizational-unit-detail-edit.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOrganizationalUnitDetailEditRoutable extends SharedAbstractDetailEditCommonRoutable<OrganizationalUnit, AdminOrganizationalUnitStateModel> implements OnInit {
  @Select(AdminOrganizationalUnitState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminOrganizationalUnitState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;
  listSubmissionPoliciesObs: Observable<SubmissionPolicy[]> = MemoizedUtil.list(this._store, SharedSubmissionPolicyState);
  listPreservationPoliciesObs: Observable<PreservationPolicy[]> = MemoizedUtil.list(this._store, SharedPreservationPolicyState);
  listRoleObs: Observable<Role[]> = MemoizedUtil.list(this._store, SharedRoleState);

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedOrganizationalUnitActionNameSpace;

  readonly KEY_PARAM_NAME: keyof OrganizationalUnit & string = "name";

  private currentTab: Tab;

  listTabs: Tab[] = [
    {
      id: TabEnum.DATA,
      suffixUrl: AdminRoutesEnum.organizationalUnitData,
      icon: IconNameEnum.metadata,
      titleToTranslate: LabelTranslateEnum.detail,
      route: () => [...this.rootUrl, AdminRoutesEnum.organizationalUnitData],
    },
    {
      id: TabEnum.ADDITIONAL_FIELDS_FORM,
      suffixUrl: AdminRoutesEnum.organizationalUnitAdditionalFieldsForm,
      icon: IconNameEnum.files,
      titleToTranslate: MARK_AS_TRANSLATABLE("admin.organizationalUnit.tab.additionalFieldsForm"),
      route: () => [...this.rootUrl, AdminRoutesEnum.organizationalUnitAdditionalFieldsForm],
    },
  ];

  private get rootUrl(): string[] {
    return [AppRoutesEnum.admin, AdminRoutesEnum.organizationalUnit, AdminRoutesEnum.organizationalUnitDetail, this._resId];
  }

  listExtraButtons: ExtraButtonToolbar<OrganizationalUnit>[] = [
    {
      color: "primary",
      typeButton: "flat-button",
      icon: IconNameEnum.save,
      labelToTranslate: (current) => LabelTranslateEnum.save,
      order: 40,
      callback: () => this._adminOrganizationalUnitService?.formPresentational?.onSubmit(),
      displayCondition: () => this.isEdit,
      disableCondition: () => this._adminOrganizationalUnitService?.formPresentational?.form?.pristine || this._adminOrganizationalUnitService?.formPresentational?.form?.invalid,
    },
    {
      color: "primary",
      typeButton: "button",
      icon: IconNameEnum.create,
      labelToTranslate: (current) => MARK_AS_TRANSLATABLE("admin.organizationalUnit.button.createAdditionalFieldsForm"),
      order: 40,
      callback: () => this.createAdditionalFieldsFromScratch(this._resId),
    },
  ];

  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              public readonly _dialog: MatDialog,
              private readonly _adminOrganizationalUnitService: AdminOrganizationalUnitService) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.admin_organizationalUnit, adminOrganizationalUnitActionNameSpace, LocalStateEnum.admin);
  }

  ngOnInit(): void {
    super.ngOnInit();
    this._store.dispatch(new SharedResearchDomainAction.GetSource());
  }

  setCurrentTab($event: Tab): void {
    this.currentTab = $event;
  }

  protected getSubResourceWithParentId(id: string): void {
  }

  private createAdditionalFieldsFromScratch(_resId: string): void {
    this._dialog.open(AdminOrganizationalUnitAdditionalFieldsDetailCreateUpdateDialog, {
      data: {
        parentResId: this._resId,
        additionalFieldsForm: undefined,
        mode: "create",
      } as AdminOrganizationalUnitAdditionalFieldsDetailCreateEditDialogData,
    });
  }

  @Override()
  backToDetail(): void {
    super.backToDetail([...this.rootUrl, AdminRoutesEnum.organizationalUnitData]);
  }
}

enum TabEnum {
  DATA = "DATA",
  ADDITIONAL_FIELDS_FORM = "ADDITIONAL_FIELDS_FORM",
}
