import {PersonRole} from "@admin/models/person-role.model";
import {adminOrganizationalUnitActionNameSpace} from "@admin/organizational-unit/stores/admin-organizational-unit.action";
import {
  AdminOrganizationalUnitState,
  AdminOrganizationalUnitStateModel,
} from "@admin/organizational-unit/stores/admin-organizational-unit.state";
import {AdminOrganizationalUnitFundingAgencyState} from "@admin/organizational-unit/stores/funding-agency/admin-organizational-unit-funding-agency.state";
import {AdminOrganizationalUnitInstitutionState} from "@admin/organizational-unit/stores/institution/admin-organizational-unit-institution.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnInit,
} from "@angular/core";
import {AppPersonState} from "@app/stores/person/app-person.state";
import {AppSystemPropertyState} from "@app/stores/system-property/app-system-property.state";
import {Enums} from "@enums";
import {
  DisseminationPolicy,
  FundingAgency,
  Institution,
  OrganizationalUnit,
  PreservationPolicy,
  Role,
  SubmissionPolicy,
  SystemProperty,
} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {SharedDisseminationPolicyState} from "@shared/stores/dissemination-policy/shared-dissemination-policy.state";
import {sharedOrganizationalUnitActionNameSpace} from "@shared/stores/organizational-unit/shared-organizational-unit.action";
import {SharedPreservationPolicyState} from "@shared/stores/preservation-policy/shared-preservation-policy.state";
import {SharedResearchDomainAction} from "@shared/stores/research-domain/shared-research-domain.action";
import {SharedResearchDomainState} from "@shared/stores/research-domain/shared-research-domain.state";
import {SharedRoleState} from "@shared/stores/role/shared-role.state";
import {SharedSubmissionPolicyState} from "@shared/stores/submission-policy/shared-submission-policy.state";
import {Observable} from "rxjs";
import {
  MemoizedUtil,
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-organizational-unit-create-routable",
  templateUrl: "./admin-organizational-unit-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOrganizationalUnitCreateRoutable extends SharedAbstractCreateRoutable<OrganizationalUnit, AdminOrganizationalUnitStateModel> implements OnInit {
  listSubmissionPoliciesObs: Observable<SubmissionPolicy[]> = MemoizedUtil.list(this._store, SharedSubmissionPolicyState);
  @Select(AdminOrganizationalUnitState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminOrganizationalUnitState.isReadyToBeDisplayedInCreateMode) isReadyToBeDisplayedInCreateModeObs: Observable<boolean>;
  listPreservationPoliciesObs: Observable<PreservationPolicy[]> = MemoizedUtil.list(this._store, SharedPreservationPolicyState);
  listDisseminationPoliciesObs: Observable<DisseminationPolicy[]> = MemoizedUtil.list(this._store, SharedDisseminationPolicyState);
  listRoleObs: Observable<Role[]> = MemoizedUtil.list(this._store, SharedRoleState);
  selectedFundingAgenciesObs: Observable<FundingAgency[]> = MemoizedUtil.selected(this._store, AdminOrganizationalUnitFundingAgencyState);
  selectedInstitutionsObs: Observable<Institution[]> = MemoizedUtil.selected(this._store, AdminOrganizationalUnitInstitutionState);
  researchDomainSourcesObs: Observable<string[]> = MemoizedUtil.select(this._store, SharedResearchDomainState, state => state.sources);
  systemPropertyObs: Observable<SystemProperty> = MemoizedUtil.select(this._store, AppSystemPropertyState, state => state.current);

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedOrganizationalUnitActionNameSpace;

  selectedPersonRole: PersonRole[] = [
    {
      isReadonly: true,
      resId: MemoizedUtil.selectSnapshot(this._store, AppPersonState, state => state.current.resId),
      roles: [{resId: Enums.Role.RoleEnum.MANAGER}],
    },
  ];

  constructor(protected readonly _store: Store,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store, _actions$, _changeDetector, LocalStateEnum.admin_organizationalUnit, adminOrganizationalUnitActionNameSpace, LocalStateEnum.admin);
  }

  ngOnInit(): void {
    super.ngOnInit();
    this._store.dispatch(new SharedResearchDomainAction.GetSource());
  }
}
