import {
  AdminOrganizationalUnitAdditionalFieldsDetailCreateEditDialogData,
  AdminOrganizationalUnitAdditionalFieldsDetailCreateUpdateDialog,
} from "@admin/organizational-unit/components/dialogs/admin-organizational-unit-additional-fields-detail-create-update/admin-organizational-unit-additional-fields-detail-create-update.dialog";
import {
  AdminOrganizationalUnitAdditionalFieldsRenameDialog,
  AdminOrganizationalUnitAdditionalFieldsRenameDialogData,
} from "@admin/organizational-unit/components/dialogs/admin-organizational-unit-additional-fields-rename/admin-organizational-unit-additional-fields-rename.dialog";
import {AdminOrganizationalUnitAdditionalFieldsFormAction} from "@admin/organizational-unit/stores/additional-fields-form/admin-organizational-unit-additional-fields-form.action";
import {AdminOrganizationalUnitAdditionalFieldsFormState} from "@admin/organizational-unit/stores/additional-fields-form/admin-organizational-unit-additional-fields-form.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {DepositDataFile} from "@deposit/models/deposit-data-file.model";
import {AdditionalFieldsForm} from "@models";
import {Store} from "@ngxs/store";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {AppRoutesEnum} from "@shared/enums/routes.enum";
import {DataTableActions} from "@shared/models/data-table-actions.model";
import {DataTableColumns} from "@shared/models/data-table-columns.model";
import {Observable} from "rxjs";
import {
  CompositionState,
  isNullOrUndefined,
  MARK_AS_TRANSLATABLE,
  MemoizedUtil,
  OrderEnum,
  QueryParameters,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-organizational-unit-additional-fields-list-routable",
  templateUrl: "./admin-organizational-unit-additional-fields-list.routable.html",
  styleUrls: ["./admin-organizational-unit-additional-fields-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOrganizationalUnitAdditionalFieldsListRoutable {
  isLoadingObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, AdminOrganizationalUnitAdditionalFieldsFormState);

  _orgUnitResId: string;
  _resId: string;

  additionalFieldsFormObs: Observable<AdditionalFieldsForm[]> = CompositionState.list(this._store, AdminOrganizationalUnitAdditionalFieldsFormState);
  queryParametersObs: Observable<QueryParameters> = MemoizedUtil.select(this._store, AdminOrganizationalUnitAdditionalFieldsFormState, (state) => state.queryParameters);

  columns: DataTableColumns<AdditionalFieldsForm>[];

  actions: DataTableActions<DepositDataFile>[] = [
    {
      logo: IconNameEnum.edit,
      callback: (additionalFieldsForm: AdditionalFieldsForm) => this.renameVersion(this._resId, additionalFieldsForm),
      placeholder: current => LabelTranslateEnum.rename,
    },
    {
      logo: IconNameEnum.create,
      callback: (additionalFieldsForm: AdditionalFieldsForm) => this.createNewVersionFromExistingOne(this._resId, additionalFieldsForm),
      placeholder: current => MARK_AS_TRANSLATABLE("crud.list.action.createNewVersionFromExistingOne"),
    },
  ];

  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              private readonly _changeDetector: ChangeDetectorRef,
              public readonly _dialog: MatDialog) {
    this.retrieveResIdFromUrl();
    this.defineColumns();
  }

  protected retrieveResIdFromUrl(): void {
    this._orgUnitResId = this._route.snapshot.paramMap.get(AppRoutesEnum.paramIdWithoutPrefixParam);
    if (isNullOrUndefined(this._orgUnitResId)) {
      this._orgUnitResId = this._route.parent.snapshot.paramMap.get(AppRoutesEnum.paramIdWithoutPrefixParam);
    }
  }

  onQueryParametersEvent(queryParameters: QueryParameters): void {
    this._store.dispatch(new AdminOrganizationalUnitAdditionalFieldsFormAction.ChangeQueryParameters(this._orgUnitResId, queryParameters));
    this._changeDetector.detectChanges(); // Allow to display spinner the first time
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "name",
        header: LabelTranslateEnum.nameLabel,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "creation.when" as any,
        header: LabelTranslateEnum.created,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.ascending,
        isFilterable: true,
        isSortable: true,
      },
    ];
  }

  select(additionalFieldsForm: AdditionalFieldsForm): void {
    this._dialog.open(AdminOrganizationalUnitAdditionalFieldsDetailCreateUpdateDialog, {
      data: {
        parentResId: this._orgUnitResId,
        additionalFieldsForm: additionalFieldsForm,
        mode: "detail",
      } as AdminOrganizationalUnitAdditionalFieldsDetailCreateEditDialogData,
    });
  }

  private renameVersion(_resId: string, additionalFieldsForm: AdditionalFieldsForm): void {
    this._dialog.open(AdminOrganizationalUnitAdditionalFieldsRenameDialog, {
      data: {
        parentResId: this._orgUnitResId,
        additionalFieldsForm: additionalFieldsForm,
      } as AdminOrganizationalUnitAdditionalFieldsRenameDialogData,
    });
  }

  private createNewVersionFromExistingOne(_resId: string, additionalFieldsForm: AdditionalFieldsForm): void {
    this._dialog.open(AdminOrganizationalUnitAdditionalFieldsDetailCreateUpdateDialog, {
      data: {
        parentResId: this._orgUnitResId,
        additionalFieldsForm: additionalFieldsForm,
        mode: "update",
      } as AdminOrganizationalUnitAdditionalFieldsDetailCreateEditDialogData,
    });
  }
}
