import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
} from "@angular/core";
import {
  FormBuilder,
  Validators,
} from "@angular/forms";
import {BreakpointService} from "@app/shared/services/breakpoint.service";
import {Enums} from "@enums";
import {environment} from "@environments/environment";
import {AdditionalFieldsForm} from "@models";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {
  KeyValue,
  PropertyName,
  SolidifyValidator,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-organizational-unit-additional-fields-form",
  templateUrl: "./admin-organizational-unit-additional-fields-form.presentational.html",
  styleUrls: ["../../../../../../shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOrganizationalUnitAdditionalFieldsFormPresentational extends SharedAbstractFormPresentational<AdditionalFieldsForm> {
  readonly TIME_BEFORE_DISPLAY_TOOLTIP: number = environment.timeBeforeDisplayTooltipOnInput;
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  listFormType: KeyValue[] = Enums.FormDescription.LanguageEnumTranslate;

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              protected readonly _elementRef: ElementRef,
              private readonly _fb: FormBuilder,
              public readonly breakpointService: BreakpointService) {
    super(_changeDetectorRef, _elementRef);
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.type]: [Enums.FormDescription.TypeEnum.FORMLY, [Validators.required, SolidifyValidator]],
      [this.formDefinition.name]: ["", [SolidifyValidator]],
      [this.formDefinition.description]: [""],
    });

  }

  protected bindFormTo(additionalFieldsForm: AdditionalFieldsForm): void {
    this.form = this._fb.group({
      [this.formDefinition.type]: [additionalFieldsForm.type, [Validators.required, SolidifyValidator]],
      [this.formDefinition.name]: [additionalFieldsForm.name, [SolidifyValidator]],
      [this.formDefinition.description]: [additionalFieldsForm.description],
    });
  }

  protected treatmentBeforeSubmit(additionalFieldsForm: AdditionalFieldsForm | any): AdditionalFieldsForm {
    return additionalFieldsForm;
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() type: string;
  @PropertyName() name: string;
  @PropertyName() description: string;
  @PropertyName() creation: string;
  @PropertyName() lastUpdate: string;
}
