import {AdminOrganizationalUnitAdditionalFieldsFormAction} from "@admin/organizational-unit/stores/additional-fields-form/admin-organizational-unit-additional-fields-form.action";
import {AdminOrganizationalUnitAdditionalFieldsFormState} from "@admin/organizational-unit/stores/additional-fields-form/admin-organizational-unit-additional-fields-form.state";
import {
  ChangeDetectionStrategy,
  Component,
  Inject,
  OnInit,
} from "@angular/core";
import {
  AbstractControl,
  FormBuilder,
  FormGroup,
} from "@angular/forms";
import {
  MAT_DIALOG_DATA,
  MatDialogRef,
} from "@angular/material/dialog";
import {AdditionalFieldsForm} from "@models";
import {
  Actions,
  ofActionCompleted,
  Store,
} from "@ngxs/store";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {Observable} from "rxjs";
import {
  take,
  tap,
} from "rxjs/operators";
import {
  FormValidationHelper,
  isTrue,
  MemoizedUtil,
  PropertyName,
  SolidifyValidator,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-organizational-unit-additional-fields-rename-dialog",
  templateUrl: "./admin-organizational-unit-additional-fields-rename.dialog.html",
  styleUrls: ["./admin-organizational-unit-additional-fields-rename.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOrganizationalUnitAdditionalFieldsRenameDialog extends SharedAbstractContainer implements OnInit {
  isLoadingObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, AdminOrganizationalUnitAdditionalFieldsFormState);

  form: FormGroup;
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  constructor(private readonly _store: Store,
              private readonly _actions$: Actions,
              private readonly _dialogRef: MatDialogRef<AdminOrganizationalUnitAdditionalFieldsRenameDialog>,
              @Inject(MAT_DIALOG_DATA) public data: AdminOrganizationalUnitAdditionalFieldsRenameDialogData,
              private readonly _fb: FormBuilder) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.form = this._fb.group({
      [this.formDefinition.name]: [this.data.additionalFieldsForm.name, SolidifyValidator],
    });
  }

  close(): void {
    this._dialogRef.close();
  }

  onSubmit(): void {
    this._store.dispatch(new AdminOrganizationalUnitAdditionalFieldsFormAction.Update(this.data.parentResId, {
      resId: this.data.additionalFieldsForm.resId,
      name: this.form.get(this.formDefinition.name).value,
    }));

    this.subscribe(this._actions$.pipe(
      ofActionCompleted(AdminOrganizationalUnitAdditionalFieldsFormAction.UpdateSuccess),
      take(1),
      tap((result) => {
        if (isTrue(result.result.successful)) {
          this._dialogRef.close();
          this._store.dispatch(new AdminOrganizationalUnitAdditionalFieldsFormAction.GetAll(this.data.parentResId));
        }
      }),
    ));
  }

  getFormControl(key: string): AbstractControl {
    return FormValidationHelper.getFormControl(this.form, key);
  }

  get formValidationHelper(): typeof FormValidationHelper {
    return FormValidationHelper;
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() name: string;
}

export interface AdminOrganizationalUnitAdditionalFieldsRenameDialogData {
  parentResId: string;
  additionalFieldsForm: AdditionalFieldsForm;
}
