import {AdminOrganizationalUnitAdditionalFieldsFormAction} from "@admin/organizational-unit/stores/additional-fields-form/admin-organizational-unit-additional-fields-form.action";
import {AdminOrganizationalUnitAdditionalFieldsFormState} from "@admin/organizational-unit/stores/additional-fields-form/admin-organizational-unit-additional-fields-form.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  Inject,
  OnInit,
  ViewChild,
} from "@angular/core";
import {
  MAT_DIALOG_DATA,
  MatDialog,
  MatDialogRef,
} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {
  AdditionalFieldsForm,
  OaiSet,
} from "@models";
import {
  Actions,
  ofActionCompleted,
  Store,
} from "@ngxs/store";
import {SharedAbstractDialog} from "@shared/components/dialogs/shared-abstract/shared-abstract.dialog";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {FormControlKey} from "@shared/models/form-control-key.model";
import {Observable} from "rxjs";
import {
  take,
  tap,
} from "rxjs/operators";
import {
  isTrue,
  MARK_AS_TRANSLATABLE,
  MemoizedUtil,
  ModelFormControlEvent,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-organizational-unit-additional-fields-detail-create-update-dialog",
  templateUrl: "./admin-organizational-unit-additional-fields-detail-create-update.dialog.html",
  styleUrls: ["./admin-organizational-unit-additional-fields-detail-create-update.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOrganizationalUnitAdditionalFieldsDetailCreateUpdateDialog extends SharedAbstractDialog implements OnInit {
  isLoadingObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, AdminOrganizationalUnitAdditionalFieldsFormState);
  confirmToTranslate: string;

  @ViewChild("formPresentational")
  readonly formPresentational: SharedAbstractFormPresentational<OaiSet>;

  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _dialog: MatDialog,
              protected readonly _dialogRef: MatDialogRef<AdminOrganizationalUnitAdditionalFieldsDetailCreateUpdateDialog>,
              @Inject(MAT_DIALOG_DATA) readonly data: AdminOrganizationalUnitAdditionalFieldsDetailCreateEditDialogData) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();

    if (this.data.mode === "update") {
      this.titleToTranslate = MARK_AS_TRANSLATABLE("admin.organizationalUnit.additionalFields.modal.detailCreateUpdate.title.update");
      this.confirmToTranslate = MARK_AS_TRANSLATABLE("admin.organizationalUnit.additionalFields.modal.detailCreateUpdate.button.confirm");
    } else if (this.data.mode === "detail") {
      this.titleToTranslate = MARK_AS_TRANSLATABLE("admin.organizationalUnit.additionalFields.modal.detailCreateUpdate.title.detail");
      this.confirmToTranslate = MARK_AS_TRANSLATABLE("admin.organizationalUnit.additionalFields.modal.detailCreateUpdate.button.confirm");
    } else if (this.data.mode === "create") {
      this.titleToTranslate = MARK_AS_TRANSLATABLE("admin.organizationalUnit.additionalFields.modal.detailCreateUpdate.title.create");
      this.confirmToTranslate = MARK_AS_TRANSLATABLE("admin.organizationalUnit.additionalFields.modal.detailCreateUpdate.button.confirm");
    }
  }

  update($event: ModelFormControlEvent<AdditionalFieldsForm>): void {

  }

  checkAvailable($event: FormControlKey): void {

  }

  updateCanDeactivate($event: boolean): void {

  }

  confirm(additionalFieldsForm: AdditionalFieldsForm): void {
    this.subscribe(this._actions$.pipe(
      ofActionCompleted(AdminOrganizationalUnitAdditionalFieldsFormAction.CreateSuccess),
      take(1),
      tap((result) => {
        if (isTrue(result.result.successful)) {
          this._dialogRef.close();
        }
      }),
    ));
    this._store.dispatch(new AdminOrganizationalUnitAdditionalFieldsFormAction.Create(this.data.parentResId, additionalFieldsForm));
  }
}

export interface AdminOrganizationalUnitAdditionalFieldsDetailCreateEditDialogData {
  parentResId: string;
  additionalFieldsForm: AdditionalFieldsForm;
  mode: "update" | "create" | "detail";
}
