import {AdminOrganizationalUnitAdditionalFieldsListRoutable} from "@admin/organizational-unit/components/routables/admin-organizational-unit-additional-fields-list/admin-organizational-unit-additional-fields-list.routable";
import {AdminOrganizationalUnitCreateRoutable} from "@admin/organizational-unit/components/routables/admin-organizational-unit-create/admin-organizational-unit-create.routable";
import {AdminOrganizationalUnitDetailEditRoutable} from "@admin/organizational-unit/components/routables/admin-organizational-unit-detail-edit/admin-organizational-unit-detail-edit.routable";
import {AdminOrganizationalUnitListRoutable} from "@admin/organizational-unit/components/routables/admin-organizational-unit-list/admin-organizational-unit-list.routable";
import {AdminOrganizationalUnitMetadataRoutable} from "@admin/organizational-unit/components/routables/admin-organizational-unit-metadata/admin-organizational-unit-metadata.routable";
import {AdminOrganizationalUnitState} from "@admin/organizational-unit/stores/admin-organizational-unit.state";
import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {ModuleLoadedEnum} from "@shared/enums/module-loaded.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminOrganizationalUnitListRoutable,
    data: {},
  },
  {
    path: AdminRoutesEnum.organizationalUnitDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    redirectTo: AdminRoutesEnum.organizationalUnitDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId + AppRoutesEnum.separator + AdminRoutesEnum.organizationalUnitData,
    pathMatch: "full",
  },
  {
    path: AdminRoutesEnum.organizationalUnitDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminOrganizationalUnitDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: AdminOrganizationalUnitState.currentTitle,
    },
    children: [
      {
        path: AdminRoutesEnum.organizationalUnitData,
        component: AdminOrganizationalUnitMetadataRoutable,
        data: {
          breadcrumb: LabelTranslateEnum.detail,
        },
        children: [
          {
            path: AdminRoutesEnum.organizationalUnitEdit,
            data: {
              breadcrumb: LabelTranslateEnum.edit,
            },
            canDeactivate: [CanDeactivateGuard],
          },
        ],
      },
      {
        path: AdminRoutesEnum.organizationalUnitAdditionalFieldsForm,
        component: AdminOrganizationalUnitAdditionalFieldsListRoutable,
        data: {
          breadcrumb: LabelTranslateEnum.additionalMetadata,
        },
      },
    ],
  },
  {
    path: AdminRoutesEnum.organizationalUnitCreate,
    component: AdminOrganizationalUnitCreateRoutable,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminOrganizationalUnitRoutingModule {
  constructor() {
    window[ModuleLoadedEnum.adminOrganizationalUnitModuleLoaded] = true;
  }
}
