import {adminOAuth2ClientActionNameSpace} from "@admin/oauth2-client/stores/admin-oauth2-client.action";
import {
  AdminOAuth2ClientState,
  AdminOAuth2ClientStateModel,
} from "@admin/oauth2-client/stores/admin-oauth2-client.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {Oauth2Client} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractDetailEditCommonRoutable} from "@shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {sharedOauth2ClientActionNameSpace} from "@shared/stores/oauth-2-client/shared-oauth-2-client.action";
import {Observable} from "rxjs";
import {
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-oauth2-client-detail-edit-routable",
  templateUrl: "./admin-oauth2-client-detail-edit.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOauth2ClientDetailEditRoutable extends SharedAbstractDetailEditCommonRoutable<Oauth2Client, AdminOAuth2ClientStateModel> {
  @Select(AdminOAuth2ClientState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminOAuth2ClientState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedOauth2ClientActionNameSpace;

  readonly KEY_PARAM_NAME: keyof Oauth2Client & string = "name";

  constructor(protected _store: Store,
              protected _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              public _dialog: MatDialog) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.admin_oauth2Client, adminOAuth2ClientActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }

}
