import {adminOAuth2ClientActionNameSpace} from "@admin/oauth2-client/stores/admin-oauth2-client.action";
import {
  AdminOAuth2ClientState,
  AdminOAuth2ClientStateModel,
} from "@admin/oauth2-client/stores/admin-oauth2-client.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnInit,
  ViewChild,
} from "@angular/core";
import {Oauth2Client} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {sharedOauth2ClientActionNameSpace} from "@shared/stores/oauth-2-client/shared-oauth-2-client.action";
import {Observable} from "rxjs";
import {
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-oauth2-create-routable",
  templateUrl: "./admin-oauth2-client-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOauth2ClientCreateRoutable extends SharedAbstractCreateRoutable<Oauth2Client, AdminOAuth2ClientStateModel> implements OnInit {
  @Select(AdminOAuth2ClientState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminOAuth2ClientState.isReadyToBeDisplayedInCreateMode) isReadyToBeDisplayedInCreateModeObs: Observable<boolean>;

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedOauth2ClientActionNameSpace;

  @ViewChild("formPresentational")
  readonly formPresentational: SharedAbstractFormPresentational<Oauth2Client>;

  constructor(protected readonly _store: Store,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store, _actions$, _changeDetector, LocalStateEnum.admin_oauth2Client, adminOAuth2ClientActionNameSpace, LocalStateEnum.admin);
  }

  ngOnInit(): void {
    super.ngOnInit();
  }
}
