import {AdminOauth2ClientRoutingModule} from "@admin/oauth2-client/admin-oauth2-client-routing.module";
import {AdminOAtuh2ClientFormPresentational} from "@admin/oauth2-client/components/presentationals/admin-oauth2-client-form/admin-oauth2-client-form.presentational";
import {AdminOauth2ClientCreateRoutable} from "@admin/oauth2-client/components/routables/admin-oauth2-client-create/admin-oauth2-client-create.routable";
import {AdminOauth2ClientDetailEditRoutable} from "@admin/oauth2-client/components/routables/admin-oauth2-client-detail-edit/admin-oauth2-client-detail-edit.routable";
import {AdminOAuth2ClientListRoutable} from "@admin/oauth2-client/components/routables/admin-oauth2-client-list/admin-oauth2-client-list.routable";
import {AdminOAuth2ClientState} from "@admin/oauth2-client/stores/admin-oauth2-client.state";
import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";

const routables = [
  AdminOAuth2ClientListRoutable,
  AdminOauth2ClientDetailEditRoutable,
  AdminOauth2ClientCreateRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
  AdminOAtuh2ClientFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminOauth2ClientRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminOAuth2ClientState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminOauth2ClientModule {
}
