import {AdminOauth2ClientCreateRoutable} from "@admin/oauth2-client/components/routables/admin-oauth2-client-create/admin-oauth2-client-create.routable";
import {AdminOauth2ClientDetailEditRoutable} from "@admin/oauth2-client/components/routables/admin-oauth2-client-detail-edit/admin-oauth2-client-detail-edit.routable";
import {AdminOAuth2ClientListRoutable} from "@admin/oauth2-client/components/routables/admin-oauth2-client-list/admin-oauth2-client-list.routable";
import {AdminOAuth2ClientState} from "@admin/oauth2-client/stores/admin-oauth2-client.state";
import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminOAuth2ClientListRoutable,
    data: {},
  },
  {
    path: AdminRoutesEnum.oauth2clientDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminOauth2ClientDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: AdminOAuth2ClientState.currentTitle,
    },
    children: [
      {
        path: AdminRoutesEnum.oauth2clientEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
  {
    component: AdminOauth2ClientCreateRoutable,
    path: AdminRoutesEnum.oauth2clientCreate,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminOauth2ClientRoutingModule {
}
