import {adminOaiSetActionNameSpace} from "@admin/oai-set/stores/admin-oai-set.action";
import {
  AdminOaiSetState,
  AdminOaiSetStateModel,
} from "@admin/oai-set/stores/admin-oai-set.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {OaiSet} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractDetailEditCommonRoutable} from "@shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {sharedOaiSetActionNameSpace} from "@shared/stores/oai-set/shared-oai-set.action";
import {Observable} from "rxjs";
import {
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-oai-set-detail-edit-routable",
  templateUrl: "./admin-oai-set-detail-edit.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOaiSetDetailEditRoutable extends SharedAbstractDetailEditCommonRoutable<OaiSet, AdminOaiSetStateModel> {
  @Select(AdminOaiSetState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminOaiSetState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedOaiSetActionNameSpace;

  readonly KEY_PARAM_NAME: keyof OaiSet & string = "name";

  constructor(protected _store: Store,
              protected _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              public _dialog: MatDialog) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.admin_oaiSet, adminOaiSetActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }
}
