import {adminOaiSetActionNameSpace} from "@admin/oai-set/stores/admin-oai-set.action";
import {
  AdminOaiSetState,
  AdminOaiSetStateModel,
} from "@admin/oai-set/stores/admin-oai-set.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ViewChild,
} from "@angular/core";
import {OaiSet} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {sharedOaiSetActionNameSpace} from "@shared/stores/oai-set/shared-oai-set.action";
import {Observable} from "rxjs";
import {
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-oai-set-create-routable",
  templateUrl: "./admin-oai-set-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOaiSetCreateRoutable extends SharedAbstractCreateRoutable<OaiSet, AdminOaiSetStateModel> {
  @Select(AdminOaiSetState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminOaiSetState.isReadyToBeDisplayedInCreateMode) isReadyToBeDisplayedInCreateModeObs: Observable<boolean>;

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedOaiSetActionNameSpace;

  @ViewChild("formPresentational")
  readonly formPresentational: SharedAbstractFormPresentational<OaiSet>;

  constructor(protected readonly _store: Store,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store, _actions$, _changeDetector, LocalStateEnum.admin_oaiSet, adminOaiSetActionNameSpace, LocalStateEnum.admin);
  }
}
