import {
  AdminOaiSetAction,
  adminOaiSetActionNameSpace,
} from "@admin/oai-set/stores/admin-oai-set.action";
import {
  AdminOaiSetState,
  AdminOaiSetStateModel,
} from "@admin/oai-set/stores/admin-oai-set.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ViewChild,
} from "@angular/core";
import {
  OaiSet,
  OrganizationalUnit,
} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {SharedOrganizationalUnitState} from "@shared/stores/organizational-unit/shared-organizational-unit.state";
import {Observable} from "rxjs";
import {
  MemoizedUtil,
  ModelFormControlEvent,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-oai-set-bulk-create-routable",
  templateUrl: "./admin-oai-set-bulk-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOaiSetBulkCreateRoutable extends SharedAbstractCreateRoutable<OaiSet, AdminOaiSetStateModel> {
  @Select(AdminOaiSetState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminOaiSetState.isReadyToBeDisplayedInCreateMode) isReadyToBeDisplayedInCreateModeObs: Observable<boolean>;
  listOrgUnit: Observable<OrganizationalUnit[]> = MemoizedUtil.list(this._store, SharedOrganizationalUnitState);

  @ViewChild("formPresentational")
  readonly formPresentational: SharedAbstractFormPresentational<OaiSet>;

  constructor(protected readonly _store: Store,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store, _actions$, _changeDetector, LocalStateEnum.admin_oaiSet, adminOaiSetActionNameSpace, LocalStateEnum.admin);
  }

  create(modelFormControlEvent: ModelFormControlEvent<OaiSet>): void {
    super.saveInProgress();
    this._store.dispatch(new AdminOaiSetAction.BulkCreate(modelFormControlEvent.model.organizationalUnits));
  }
}
