import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
} from "@angular/core";
import {
  FormBuilder,
  Validators,
} from "@angular/forms";
import {environment} from "@environments/environment";
import {OaiSet} from "@models";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {
  PropertyName,
  SolidifyValidator,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-oai-set-form",
  templateUrl: "./admin-oai-set-form.presentational.html",
  styleUrls: ["../../../../../../shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOaiSetFormPresentational extends SharedAbstractFormPresentational<OaiSet> {
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  readonly TIME_BEFORE_DISPLAY_TOOLTIP: number = environment.timeBeforeDisplayTooltipOnInput;

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              protected readonly _elementRef: ElementRef,
              private readonly _fb: FormBuilder) {
    super(_changeDetectorRef, _elementRef);
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.spec]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.name]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.description]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.query]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.enabled]: [false, [SolidifyValidator]],
    });
  }

  protected bindFormTo(oaiSets: OaiSet): void {
    this.form = this._fb.group({
      [this.formDefinition.spec]: [oaiSets.spec, [Validators.required, SolidifyValidator]],
      [this.formDefinition.name]: [oaiSets.name, [Validators.required, SolidifyValidator]],
      [this.formDefinition.description]: [oaiSets.description, [Validators.required, SolidifyValidator]],
      [this.formDefinition.query]: [oaiSets.query, [Validators.required, SolidifyValidator]],
      [this.formDefinition.enabled]: [oaiSets.enabled, [SolidifyValidator]],
    });
  }

  protected treatmentBeforeSubmit(oaiSets: OaiSet): OaiSet {
    return oaiSets;
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() spec: string;
  @PropertyName() name: string;
  @PropertyName() description: string;
  @PropertyName() query: string;
  @PropertyName() enabled: string;
}
