import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
  Input,
} from "@angular/core";
import {FormBuilder} from "@angular/forms";
import {
  OaiSet,
  OrganizationalUnit,
} from "@models";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {
  isNullOrUndefined,
  PropertyName,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-oai-set-bulk-form",
  templateUrl: "./admin-oai-set-bulk-form.presentational.html",
  styleUrls: ["../../../../../../shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminOaiSetBulkFormPresentational extends SharedAbstractFormPresentational<OaiSet> {
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  @Input()
  listOrgUnits: OrganizationalUnit[];

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              protected readonly _elementRef: ElementRef,
              private readonly _fb: FormBuilder) {
    super(_changeDetectorRef, _elementRef);
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.organizationalUnits]: [],
    });
  }

  protected bindFormTo(oaiSet: OaiSet): void {
  }

  protected treatmentBeforeSubmit(oaiSet: OaiSet): OaiSet {
    oaiSet.organizationalUnits = [];
    const listOrgUnitId = this.form.get(this.formDefinition.organizationalUnits).value;
    if (!isNullOrUndefined(listOrgUnitId)) {
      listOrgUnitId.forEach(resId => {
        const orgUnit = this.listOrgUnits.find(o => o.resId === resId);
        oaiSet.organizationalUnits.push(orgUnit);
      });
    }
    return oaiSet;
  }

  public onSubmit(): void {
    const model = this.treatmentBeforeSubmit(this.form.value as OaiSet);
    this._submitBS.next({
      model: model,
      formControl: this.form,
      changeDetectorRef: this._changeDetectorRef,
    });
  }

  navigateToOrgUnit(organizationalUnit: OrganizationalUnit): void {
    this.navigate([RoutesEnum.adminOrganizationalUnitDetail, organizationalUnit.resId]);
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() organizationalUnits: string;
}


