import {AdminOaiSetRoutingModule} from "@admin/oai-set/admin-oai-set-routing.module";
import {AdminOaiSetBulkFormPresentational} from "@admin/oai-set/components/presentationals/admin-oai-set-bulk-form/admin-oai-set-bulk-form.presentational";
import {AdminOaiSetFormPresentational} from "@admin/oai-set/components/presentationals/admin-oai-set-form/admin-oai-set-form.presentational";
import {AdminOaiSetBulkCreateRoutable} from "@admin/oai-set/components/routables/admin-oai-set-bulk-create/admin-oai-set-bulk-create.routable";
import {AdminOaiSetCreateRoutable} from "@admin/oai-set/components/routables/admin-oai-set-create/admin-oai-set-create.routable";
import {AdminOaiSetDetailEditRoutable} from "@admin/oai-set/components/routables/admin-oai-set-detail-edit/admin-oai-set-detail-edit.routable";
import {AdminOaiSetListRoutable} from "@admin/oai-set/components/routables/admin-oai-set-list/admin-oai-set-list.routable";
import {AdminOaiSetState} from "@admin/oai-set/stores/admin-oai-set.state";
import {NgModule} from "@angular/core";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {SharedModule} from "@shared/shared.module";

const routables = [
  AdminOaiSetCreateRoutable,
  AdminOaiSetDetailEditRoutable,
  AdminOaiSetListRoutable,
  AdminOaiSetBulkCreateRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
  AdminOaiSetFormPresentational,
  AdminOaiSetBulkFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminOaiSetRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminOaiSetState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminOaiSetModule {
}
