import {AdminOaiSetBulkCreateRoutable} from "@admin/oai-set/components/routables/admin-oai-set-bulk-create/admin-oai-set-bulk-create.routable";
import {AdminOaiSetCreateRoutable} from "@admin/oai-set/components/routables/admin-oai-set-create/admin-oai-set-create.routable";
import {AdminOaiSetDetailEditRoutable} from "@admin/oai-set/components/routables/admin-oai-set-detail-edit/admin-oai-set-detail-edit.routable";
import {AdminOaiSetListRoutable} from "@admin/oai-set/components/routables/admin-oai-set-list/admin-oai-set-list.routable";
import {AdminOaiSetState} from "@admin/oai-set/stores/admin-oai-set.state";
import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminOaiSetListRoutable,
    data: {},
  },
  {
    path: AdminRoutesEnum.oaiSetCreate,
    component: AdminOaiSetCreateRoutable,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },
  {
    path: AdminRoutesEnum.oaiSetDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminOaiSetDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: AdminOaiSetState.currentTitle,
    },
    children: [
      {
        path: AdminRoutesEnum.oaiSetEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
      },
    ],
  },
  {
    path: AdminRoutesEnum.oaiSetBulkCreate,
    component: AdminOaiSetBulkCreateRoutable,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminOaiSetRoutingModule {
}
