import {Injectable} from "@angular/core";
import {
  AdminResourceApiEnum,
} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {
  NotificationDlcm,
} from "@models";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {
  defaultStatusHistoryInitValue,
  StatusHistoryState,
  StatusHistoryStateModel,
} from "@shared/stores/status-history/status-history.state";
import {
  ApiService,
  NotificationService,
} from "solidify-frontend";
import {adminNotificationStatusHistoryActionnNameSpace} from "@app/features/admin/notification/stores/status-history/admin-notification-status-history.action";

export interface AdminNotificationStatusHistoryStateModel extends StatusHistoryStateModel<NotificationDlcm> {
}

@Injectable()
@State<AdminNotificationStatusHistoryStateModel>({
  name: LocalStateEnum.admin_notification_statusHistory,
  defaults: {
    ...defaultStatusHistoryInitValue(),
  },
})
export class AdminNotificationStatusHistoryState extends StatusHistoryState<AdminNotificationStatusHistoryStateModel, NotificationDlcm> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminNotificationStatusHistoryActionnNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.notifications;
  }
}
