import {adminNotificationActionNameSpace} from "@admin/notification/stores/admin-notification.action";
import {AdminNotificationStateModel} from "@admin/notification/stores/admin-notification.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {Enums} from "@enums";
import {
  NotificationDlcm,
  OrganizationalUnit,
} from "@models";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {DataTableComponentEnum} from "@shared/enums/data-table-component.enum";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RouterExtService} from "@shared/services/router-ext.service";
import {sharedOrganizationalUnitActionNameSpace} from "@shared/stores/organizational-unit/shared-organizational-unit.action";
import {SharedOrganizationalUnitState} from "@shared/stores/organizational-unit/shared-organizational-unit.state";
import {
  OrderEnum,
  ResourceNameSpace,
  Sort,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-notification-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminNotificationListRoutable extends SharedAbstractListRoutable<NotificationDlcm, AdminNotificationStateModel> {
  readonly KEY_CREATE_BUTTON: string = LabelTranslateEnum.create;
  readonly KEY_BACK_BUTTON: string | undefined = LabelTranslateEnum.backToAdmin;
  readonly KEY_PARAM_NAME: keyof NotificationDlcm & string = "notificationType";
  readonly KEY_QUERY_PARAMETER_NOTIFIED_ORGUNIT_ID: keyof NotificationDlcm | string = "notifiedOrgUnit.resId";

  sharedOrgUnitSort: Sort<OrganizationalUnit> = {
    field: "name",
    order: OrderEnum.ascending,
  };
  sharedOrgUnitActionNameSpace: ResourceNameSpace = sharedOrganizationalUnitActionNameSpace;
  sharedOrganizationalUnitState: typeof SharedOrganizationalUnitState = SharedOrganizationalUnitState;

  constructor(protected readonly _store: Store,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _route: ActivatedRoute,
              protected readonly _routerExt: RouterExtService,
              protected readonly _actions$: Actions,
              protected readonly _dialog: MatDialog) {
    super(_store, _changeDetector, _route, _routerExt, _actions$, _dialog, LocalStateEnum.admin_notification, adminNotificationActionNameSpace, {canCreate: false}, LocalStateEnum.admin);
  }

  conditionDisplayEditButton(model: NotificationDlcm | undefined): boolean {
    return false;
  }

  conditionDisplayDeleteButton(model: NotificationDlcm | undefined): boolean {
    return false;
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "notificationType.notificationCategory" as any,
        header: LabelTranslateEnum.category,
        type: FieldTypeEnum.singleSelect,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
        translate: true,
        filterEnum: Enums.Notification.CategoryEnumTranslate,
      },
      {
        field: "notificationType.resId" as any,
        header: LabelTranslateEnum.type,
        type: FieldTypeEnum.singleSelect,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
        translate: true,
        filterEnum: Enums.Notification.TypeEnumTranslate,
      },
      {
        field: "notificationStatus",
        header: LabelTranslateEnum.status,
        type: FieldTypeEnum.singleSelect,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
        translate: true,
        filterEnum: Enums.Notification.StatusEnumTranslate,
        component: DataTableComponentEnum.status,
      },
      {
        field: "emitter.person.fullName" as any,
        header: LabelTranslateEnum.emitter,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        isFilterable: false,
        isSortable: false,
      },
      {
        field: "notifiedOrgUnit.name" as any,
        header: LabelTranslateEnum.notifiedOrganizationalUnit,
        type: FieldTypeEnum.searchableSingleSelect,
        order: OrderEnum.none,
        searchableSingleSelectSort: this.sharedOrgUnitSort,
        filterableField: this.KEY_QUERY_PARAMETER_NOTIFIED_ORGUNIT_ID as any,
        sortableField: this.KEY_QUERY_PARAMETER_NOTIFIED_ORGUNIT_ID as any,
        resourceNameSpace: this.sharedOrgUnitActionNameSpace,
        resourceState: this.sharedOrganizationalUnitState as any,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "creation.when" as any,
        header: LabelTranslateEnum.created,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.none,
        isFilterable: false,
        isSortable: true,
      },
      {
        field: "lastUpdate.when" as any,
        header: LabelTranslateEnum.updated,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.descending,
        isFilterable: true,
        isSortable: true,
      },
    ];
  }
}
