import {adminNotificationActionNameSpace} from "@admin/notification/stores/admin-notification.action";
import {
  AdminNotificationState,
  AdminNotificationStateModel,
} from "@admin/notification/stores/admin-notification.state";
import {AdminNotificationStatusHistoryAction} from "@admin/notification/stores/status-history/admin-notification-status-history.action";
import {AdminNotificationStatusHistoryState} from "@admin/notification/stores/status-history/admin-notification-status-history.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {environment} from "@environments/environment";
import {
  NotificationDlcm,
  Role,
} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedHistoryDialog} from "@shared/components/dialogs/shared-history/shared-history.dialog";
import {SharedAbstractDetailEditCommonRoutable} from "@shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {StatusHistoryDialog} from "@shared/models/status-history-dialog.model";
import {StatusHistory} from "@shared/models/status-history.model";
import {sharedNotificationActionNameSpace} from "@shared/stores/notification/shared-notification.action";
import {SharedRoleState} from "@shared/stores/role/shared-role.state";
import {Observable} from "rxjs";
import {
  MemoizedUtil,
  OverrideProperty,
  QueryParameters,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-role-detail-edit-routable",
  templateUrl: "./admin-notification-detail-edit.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminNotificationDetailEditRoutable extends SharedAbstractDetailEditCommonRoutable<NotificationDlcm, AdminNotificationStateModel> {
  @Select(AdminNotificationState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminNotificationState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;

  historyObs: Observable<StatusHistory[]> = MemoizedUtil.select(this._store, AdminNotificationStatusHistoryState, state => state.history);
  isLoadingHistoryObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, AdminNotificationStatusHistoryState);
  queryParametersObs: Observable<QueryParameters> = MemoizedUtil.select(this._store, AdminNotificationStatusHistoryState, state => state.queryParameters);
  listRoleObs: Observable<Role[]> = MemoizedUtil.list(this._store, SharedRoleState);

  @OverrideProperty()
  readonly editAvailable: boolean = false;
  @OverrideProperty()
  readonly deleteAvailable: boolean = false;

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedNotificationActionNameSpace;

  readonly KEY_PARAM_NAME: keyof NotificationDlcm & string = "notificationType";

  constructor(protected _store: Store,
              protected _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              public _dialog: MatDialog) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.admin_notification, adminNotificationActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }

  showHistory(): void {
    this._dialog.open(SharedHistoryDialog, {
      width: environment.modalWidth,
      data: {
        parentId: null,
        resourceResId: this._resId,
        name: this._state,
        statusHistory: this.historyObs,
        isLoading: this.isLoadingHistoryObs,
        queryParametersObs: this.queryParametersObs,
        state: AdminNotificationStatusHistoryAction,
      } as StatusHistoryDialog,
    });
  }
}
