import {AdminNotificationRoutingModule} from "@admin/notification/admin-notification-routing.module";
import {AdminNotificationDetailEditRoutable} from "@admin/notification/components/routables/admin-notification-detail-edit/admin-notification-detail-edit.routable";
import {AdminNotificationListRoutable} from "@admin/notification/components/routables/admin-notification-list/admin-notification-list.routable";
import {AdminNotificationState} from "@admin/notification/stores/admin-notification.state";
import {AdminNotificationStatusHistoryState} from "@admin/notification/stores/status-history/admin-notification-status-history.state";
import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";

const routables = [
  AdminNotificationListRoutable,
  AdminNotificationDetailEditRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminNotificationRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminNotificationState,
      AdminNotificationStatusHistoryState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminNotificationModule {
}
