import {AdminNotificationDetailEditRoutable} from "@admin/notification/components/routables/admin-notification-detail-edit/admin-notification-detail-edit.routable";
import {AdminNotificationListRoutable} from "@admin/notification/components/routables/admin-notification-list/admin-notification-list.routable";
import {AdminNotificationState} from "@admin/notification/stores/admin-notification.state";
import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminNotificationListRoutable,
    data: {},
  },
  {
    path: AdminRoutesEnum.notificationDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminNotificationDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: AdminNotificationState.currentTitle,
    },
    children: [
      {
        path: AdminRoutesEnum.notificationEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminNotificationRoutingModule {
}
