import {
  AdminMetadataTypeAction,
  adminMetadataTypeActionNameSpace,
} from "@admin/metadata-type/stores/admin-metadata-type.action";
import {
  AdminMetadataTypeState,
  AdminMetadataTypeStateModel,
} from "@admin/metadata-type/stores/admin-metadata-type.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {
  Deposit,
  MetadataType,
} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractDetailEditCommonRoutable} from "@shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {ExtraButtonToolbar} from "@shared/models/extra-button-toolbar.model";
import {sharedMetadataTypeActionNameSpace} from "@shared/stores/metadata-type/shared-metadata-type.action";
import {Observable} from "rxjs";
import {
  isNullOrUndefined,
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-metadata-type-detail-edit-routable",
  templateUrl: "./admin-metadata-type-detail-edit.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminMetadataTypeDetailEditRoutable extends SharedAbstractDetailEditCommonRoutable<MetadataType, AdminMetadataTypeStateModel> {
  @Select(AdminMetadataTypeState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminMetadataTypeState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedMetadataTypeActionNameSpace;

  readonly KEY_PARAM_NAME: keyof MetadataType & string = "name";
  readonly files: string = "files";

  listExtraButtons: ExtraButtonToolbar<Deposit>[] = [
    {
      color: "primary",
      icon: IconNameEnum.download,
      displayCondition: current => !this.isEdit,
      callback: () => this.download(),
      disableCondition: current => isNullOrUndefined(current),
      labelToTranslate: (current) => LabelTranslateEnum.download,
      order: 40,
    },
  ];

  constructor(protected _store: Store,
              protected _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              public _dialog: MatDialog) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.admin_metadataType, adminMetadataTypeActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }

  private download(): void {
    this._store.dispatch(new AdminMetadataTypeAction.Download(this.current));
  }

  testFileUpload(file: File): void {
    this._store.dispatch(new AdminMetadataTypeAction.TestFile(this._resId, file));
  }
}
