import {adminMetadataTypeActionNameSpace} from "@admin/metadata-type/stores/admin-metadata-type.action";
import {
  AdminMetadataTypeState,
  AdminMetadataTypeStateModel,
} from "@admin/metadata-type/stores/admin-metadata-type.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ViewChild,
} from "@angular/core";
import {MetadataType} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {sharedMetadataTypeActionNameSpace} from "@shared/stores/metadata-type/shared-metadata-type.action";
import {Observable} from "rxjs";
import {
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-metadata-type-create-routable",
  templateUrl: "./admin-metadata-type-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminMetadataTypeCreateRoutable extends SharedAbstractCreateRoutable<MetadataType, AdminMetadataTypeStateModel> {
  @Select(AdminMetadataTypeState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminMetadataTypeState.isReadyToBeDisplayedInCreateMode) isReadyToBeDisplayedInCreateModeObs: Observable<boolean>;

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedMetadataTypeActionNameSpace;

  @ViewChild("formPresentational")
  readonly formPresentational: SharedAbstractFormPresentational<MetadataType>;

  constructor(protected readonly _store: Store,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store, _actions$, _changeDetector, LocalStateEnum.admin_metadataType, adminMetadataTypeActionNameSpace, LocalStateEnum.admin);
  }
}
