import {AdminMetadataTypeRoutingModule} from "@admin/metadata-type/admin-metadata-type-routing.module";
import {AdminMetadataTypeFormPresentational} from "@admin/metadata-type/components/presentationals/admin-metadata-type-form/admin-metadata-type-form.presentational";
import {AdminMetadataTypeCreateRoutable} from "@admin/metadata-type/components/routables/admin-metadata-type-create/admin-metadata-type-create.routable";
import {AdminMetadataTypeDetailEditRoutable} from "@admin/metadata-type/components/routables/admin-metadata-type-detail-edit/admin-metadata-type-detail-edit.routable";
import {AdminMetadataTypeListRoutable} from "@admin/metadata-type/components/routables/admin-metadata-type-list/admin-metadata-type-list.routable";
import {AdminMetadataTypeState} from "@admin/metadata-type/stores/admin-metadata-type.state";
import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";

const routables = [
  AdminMetadataTypeCreateRoutable,
  AdminMetadataTypeDetailEditRoutable,
  AdminMetadataTypeListRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
  AdminMetadataTypeFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminMetadataTypeRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminMetadataTypeState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminMetadataTypeModule {
}
