import {AdminMetadataTypeCreateRoutable} from "@admin/metadata-type/components/routables/admin-metadata-type-create/admin-metadata-type-create.routable";
import {AdminMetadataTypeDetailEditRoutable} from "@admin/metadata-type/components/routables/admin-metadata-type-detail-edit/admin-metadata-type-detail-edit.routable";
import {AdminMetadataTypeListRoutable} from "@admin/metadata-type/components/routables/admin-metadata-type-list/admin-metadata-type-list.routable";
import {AdminMetadataTypeState} from "@admin/metadata-type/stores/admin-metadata-type.state";
import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminMetadataTypeListRoutable,
    data: {},
  },
  {
    path: AdminRoutesEnum.metadataTypeCreate,
    component: AdminMetadataTypeCreateRoutable,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },
  {
    path: AdminRoutesEnum.metadataTypeDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminMetadataTypeDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: AdminMetadataTypeState.currentTitle,
    },
    children: [
      {
        path: AdminRoutesEnum.metadataTypeEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminMetadataTypeRoutingModule {
}
