import {adminLicenseActionNameSpace} from "@admin/license/stores/admin-license.action";
import {
  AdminLicenseState,
  AdminLicenseStateModel,
} from "@admin/license/stores/admin-license.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ViewChild,
} from "@angular/core";
import {License} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {sharedLicenseActionNameSpace} from "@shared/stores/license/shared-license.action";
import {Observable} from "rxjs";
import {
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-license-create-routable",
  templateUrl: "./admin-license-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminLicenseCreateRoutable extends SharedAbstractCreateRoutable<License, AdminLicenseStateModel> {
  @Select(AdminLicenseState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminLicenseState.isReadyToBeDisplayedInCreateMode) isReadyToBeDisplayedInCreateModeObs: Observable<boolean>;

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedLicenseActionNameSpace;

  @ViewChild("formPresentational")
  readonly formPresentational: SharedAbstractFormPresentational<License>;

  constructor(protected readonly _store: Store,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store, _actions$, _changeDetector, LocalStateEnum.admin_license, adminLicenseActionNameSpace, LocalStateEnum.admin);
  }
}
