import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
} from "@angular/core";
import {
  FormBuilder,
  Validators,
} from "@angular/forms";
import {Enums} from "@enums";
import {License} from "@models";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {RegexpUtil} from "@shared/utils/regexp.util";
import {
  KeyValue,
  PropertyName,
  SolidifyValidator,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-license-form",
  templateUrl: "./admin-license-form.presentational.html",
  styleUrls: ["../../../../../../shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminLicenseFormPresentational extends SharedAbstractFormPresentational<License> {
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  licensesStatusEnum: KeyValue[] = Enums.License.StatusEnumTranslate;
  licenseOdConformanceEnum: KeyValue[] = Enums.License.OdConformanceEnumTranslate;
  licenseOsdConformanceEnum: KeyValue[] = Enums.License.OsdConformanceEnumTranslate;

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              protected readonly _elementRef: ElementRef,
              private readonly _fb: FormBuilder) {
    super(_changeDetectorRef, _elementRef);
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.title]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.openLicenseId]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.url]: ["", [SolidifyValidator, Validators.pattern(RegexpUtil.url)]],
      [this.formDefinition.maintainer]: ["", [SolidifyValidator]],
      [this.formDefinition.odConformance]: ["", [SolidifyValidator]],
      [this.formDefinition.osdConformance]: ["", [SolidifyValidator]],
      [this.formDefinition.status]: [Enums.License.StatusEnum.Retired, [SolidifyValidator]],
      [this.formDefinition.isGeneric]: [false, [SolidifyValidator]],
      [this.formDefinition.family]: ["", [SolidifyValidator]],
      [this.formDefinition.domainContent]: [false, [SolidifyValidator]],
      [this.formDefinition.domainData]: [false, [SolidifyValidator]],
      [this.formDefinition.domainSoftware]: [false, [SolidifyValidator]],
    });
  }

  protected bindFormTo(licenses: License): void {
    this.form = this._fb.group({
      [this.formDefinition.title]: [licenses.title, [Validators.required, SolidifyValidator]],
      [this.formDefinition.openLicenseId]: [licenses.openLicenseId, [Validators.required, SolidifyValidator]],
      [this.formDefinition.url]: [licenses.url, [SolidifyValidator, Validators.pattern(RegexpUtil.url)]],
      [this.formDefinition.maintainer]: [licenses.maintainer, [SolidifyValidator]],
      [this.formDefinition.odConformance]: [licenses.odConformance, [SolidifyValidator]],
      [this.formDefinition.osdConformance]: [licenses.osdConformance, [SolidifyValidator]],
      [this.formDefinition.status]: [licenses.status, [Validators.required, SolidifyValidator]],
      [this.formDefinition.isGeneric]: [licenses.isGeneric, [SolidifyValidator]],
      [this.formDefinition.family]: [licenses.family, [SolidifyValidator]],
      [this.formDefinition.domainContent]: [licenses.domainContent, [SolidifyValidator]],
      [this.formDefinition.domainData]: [licenses.domainData, [SolidifyValidator]],
      [this.formDefinition.domainSoftware]: [licenses.domainSoftware, [SolidifyValidator]],
    });
  }

  protected treatmentBeforeSubmit(licenses: License): License {
    return licenses;
  }

}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() title: string;
  @PropertyName() openLicenseId: string;
  @PropertyName() url: string;
  @PropertyName() maintainer: string;
  @PropertyName() odConformance: string;
  @PropertyName() osdConformance: string;
  @PropertyName() status: string;
  @PropertyName() isGeneric: string;
  @PropertyName() family: string;
  @PropertyName() domainContent: string;
  @PropertyName() domainData: string;
  @PropertyName() domainSoftware: string;
}
