import {AdminLicenseRoutingModule} from "@admin/license/admin-license-routing.module";
import {AdminLicenseFormPresentational} from "@admin/license/components/presentationals/admin-license-form/admin-license-form.presentational";
import {AdminLicenseDetailEditRoutable} from "@admin/license/components/routables/admin-license-detail-edit/admin-license-detail-edit.routable";
import {AdminLicenseState} from "@admin/license/stores/admin-license.state";
import {NgModule} from "@angular/core";
import {AdminLicenseCreateRoutable} from "@app/features/admin/license/components/routables/admin-license-create/admin-license-create.routable";
import {AdminLicenseListRoutable} from "@app/features/admin/license/components/routables/admin-license-list/admin-license-list.routable";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";

const routables = [
  AdminLicenseCreateRoutable,
  AdminLicenseDetailEditRoutable,
  AdminLicenseListRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
  AdminLicenseFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminLicenseRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminLicenseState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminLicenseModule {
}
